/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalysisResult;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory0;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.diagnostics.SimpleDiagnostic;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;

public final class AnalyzerWithCompilerReport {
    @NotNull
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    private boolean hasErrors;
    @NotNull
    private final MessageCollector messageCollectorWrapper;
    @Nullable
    private AnalysisResult analysisResult;

    @NotNull
    private static CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
        }
        switch (severity) {
            case INFO: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.INFO;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
            case ERROR: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
            case WARNING: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
        }
        throw new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
    }

    public AnalyzerWithCompilerReport(final @NotNull MessageCollector collector2) {
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "<init>"));
        }
        this.hasErrors = false;
        this.analysisResult = null;
        this.messageCollectorWrapper = new MessageCollector(){

            @Override
            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                if (severity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport$1", "report"));
                }
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport$1", "report"));
                }
                if (location == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport$1", "report"));
                }
                if (CompilerMessageSeverity.ERRORS.contains((Object)severity)) {
                    AnalyzerWithCompilerReport.this.hasErrors = true;
                }
                collector2.report(severity, message, location);
            }
        };
    }

    private static boolean reportDiagnostic(@NotNull Diagnostic diagnostic, @NotNull MessageCollector messageCollector) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostic"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostic"));
        }
        if (!diagnostic.isValid()) {
            return false;
        }
        DiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumn(diagnostic);
        String render = diagnostic instanceof MyDiagnostic ? ((MyDiagnostic)diagnostic).message : DefaultErrorMessages.render(diagnostic);
        PsiFile file = diagnostic.getPsiFile();
        messageCollector.report(AnalyzerWithCompilerReport.convertSeverity(diagnostic.getSeverity()), render, MessageUtil.psiFileToMessageLocation(file, file.getName(), lineAndColumn.getLine(), lineAndColumn.getColumn()));
        return diagnostic.getSeverity() == Severity.ERROR;
    }

    private void reportIncompleteHierarchies() {
        assert (this.analysisResult != null);
        Collection<ClassDescriptor> incompletes = this.analysisResult.getBindingContext().getKeys(BindingContext.INCOMPLETE_HIERARCHY);
        if (!incompletes.isEmpty()) {
            StringBuilder message = new StringBuilder("The following classes have incomplete hierarchies:\n");
            for (ClassDescriptor incomplete : incompletes) {
                String fqName2 = DescriptorUtils.getFqName(incomplete).asString();
                message.append("    ").append(fqName2).append("\n");
            }
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportAlternativeSignatureErrors() {
        assert (this.analysisResult != null);
        BindingContext bc = this.analysisResult.getBindingContext();
        Collection<DeclarationDescriptor> descriptorsWithErrors = bc.getKeys(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor : descriptorsWithErrors) {
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
                assert (declaration instanceof PsiModifierListOwner);
                List<String> errors = bc.get(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor);
                assert (errors != null && !errors.isEmpty());
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)declaration);
                message.append(externalName).append(":\n");
                for (String error : errors) {
                    message.append("    ").append(error).append("\n");
                }
            }
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportAbiVersionErrors() {
        assert (this.analysisResult != null);
        BindingContext bindingContext = this.analysisResult.getBindingContext();
        Collection<VirtualFileKotlinClass> errorClasses = bindingContext.getKeys(TraceBasedErrorReporter.ABI_VERSION_ERRORS);
        for (VirtualFileKotlinClass kotlinClass : errorClasses) {
            Integer abiVersion = bindingContext.get(TraceBasedErrorReporter.ABI_VERSION_ERRORS, kotlinClass);
            String path = FileUtil.toSystemDependentName(kotlinClass.getFile().getPath());
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, "Class '" + JvmClassName.byClassId(kotlinClass.getClassId()) + "' was compiled with an incompatible version of Kotlin. " + "Its ABI version is " + abiVersion + ", expected ABI version is " + 19, CompilerMessageLocation.create(path, 0, 0));
        }
    }

    public static boolean reportDiagnostics(@NotNull Diagnostics diagnostics, @NotNull MessageCollector messageCollector) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        boolean hasErrors = false;
        for (Diagnostic diagnostic : DiagnosticUtils.sortedDiagnostics(diagnostics.all())) {
            hasErrors |= AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, messageCollector);
        }
        return hasErrors;
    }

    private void reportSyntaxErrors(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        for (JetFile file : files) {
            AnalyzerWithCompilerReport.reportSyntaxErrors(file, this.messageCollectorWrapper);
        }
    }

    public static SyntaxErrorReport reportSyntaxErrors(final @NotNull PsiElement file, final @NotNull MessageCollector messageCollector) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        class ErrorReportingVisitor
        extends AnalyzingUtils.PsiErrorElementVisitor {
            boolean hasErrors = false;
            boolean allErrorsAtEof = true;

            ErrorReportingVisitor() {
            }

            private <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory2, String message) {
                MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory2, message);
                AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, messageCollector);
                if (element.getTextRange().getStartOffset() != file.getTextRange().getEndOffset()) {
                    this.allErrorsAtEof = false;
                }
                this.hasErrors = true;
            }

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                String description = element.getErrorDescription();
                this.reportDiagnostic(element, SYNTAX_ERROR_FACTORY, StringUtil.isEmpty(description) ? "Syntax error" : description);
            }
        }
        ErrorReportingVisitor visitor = new ErrorReportingVisitor();
        file.accept(visitor);
        return new SyntaxErrorReport(visitor.hasErrors, visitor.allErrorsAtEof);
    }

    @Nullable
    public AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void analyzeAndReport(@NotNull Collection<JetFile> files, @NotNull Function0<AnalysisResult> analyzer) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "analyzeAndReport"));
        }
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport", "analyzeAndReport"));
        }
        this.analysisResult = analyzer.invoke();
        this.reportAbiVersionErrors();
        this.reportSyntaxErrors(files);
        AnalyzerWithCompilerReport.reportDiagnostics(this.analysisResult.getBindingContext().getDiagnostics(), this.messageCollectorWrapper);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    private static class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        private final String message;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory2, String message) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/jet/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic", "<init>"));
            }
            super(psiElement, factory2, Severity.ERROR);
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static class SyntaxErrorReport {
        private final boolean hasErrors;
        private final boolean allErrorsAtEof;

        public SyntaxErrorReport(boolean hasErrors, boolean allErrorsAtEof) {
            this.hasErrors = hasErrors;
            this.allErrorsAtEof = allErrorsAtEof;
        }

        public boolean isHasErrors() {
            return this.hasErrors;
        }

        public boolean isAllErrorsAtEof() {
            return this.allErrorsAtEof;
        }
    }
}

