/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapter
extends org.picocontainer.defaults.ConstructorInjectionComponentAdapter {
    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor2, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses, monitor2, lifecycleStrategy);
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses);
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2) {
        this(componentKey, componentImplementation, parameters2, false);
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, (Parameter[])null);
    }

    @Override
    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        List<Constructor> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (Constructor constructor2 : sortedMatchingConstructors) {
            boolean failedDependency = false;
            Class[] parameterTypes = constructor2.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor2);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor2);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor2;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor> nonMatching = ContainerUtil.newHashSet(this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)nonMatching).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    private List<Constructor> getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        for (Constructor constructor2 : this.getConstructors()) {
            if (this.parameters != null && constructor2.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor2.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor2);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator<Constructor>(){

                @Override
                public int compare(Constructor arg0, Constructor arg1) {
                    return arg1.getParameterTypes().length - arg0.getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor[] getConstructors() {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }
}

