/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;

public abstract class NotNullLazyValue<T> {
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        if (this.myValue == null) {
            this.myValue = this.compute();
        }
        T t = this.myValue;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "getValue"));
        }
        return t;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(final @NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object object2 = value;
                if (object2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
                }
                return object2;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        return notNullLazyValue;
    }
}

