/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public final class JsConditional
extends JsExpressionImpl {
    private JsExpression testExpression;
    private JsExpression elseExpression;
    private JsExpression thenExpression;

    public JsConditional() {
    }

    public JsConditional(JsExpression testExpression, JsExpression thenExpression, JsExpression elseExpression) {
        this.testExpression = testExpression;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public JsExpression getElseExpression() {
        return this.elseExpression;
    }

    public JsExpression getTestExpression() {
        return this.testExpression;
    }

    public JsExpression getThenExpression() {
        return this.thenExpression;
    }

    public void setElseExpression(JsExpression elseExpression) {
        this.elseExpression = elseExpression;
    }

    public void setTestExpression(JsExpression testExpression) {
        this.testExpression = testExpression;
    }

    public void setThenExpression(JsExpression thenExpression) {
        this.thenExpression = thenExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitConditional(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(this.testExpression);
        visitor.accept(this.thenExpression);
        visitor.accept(this.elseExpression);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.testExpression = v.accept(this.testExpression);
            this.thenExpression = v.accept(this.thenExpression);
            this.elseExpression = v.accept(this.elseExpression);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsConditional deepCopy() {
        JsExpression testCopy = AstUtil.deepCopy(this.testExpression);
        JsExpression thenCopy = AstUtil.deepCopy(this.thenExpression);
        JsExpression elseCopy = AstUtil.deepCopy(this.elseExpression);
        JsConditional jsConditional = new JsConditional(testCopy, thenCopy, elseCopy).withMetadataFrom(this);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsConditional", "deepCopy"));
        }
        return jsConditional;
    }
}

