/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"%\u0010)aA*\u001b2sCJLX\u000b^5mg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003vi&d7OC\u0002B]fTaAS*`\u000bb#&BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTqdS(U\u0019&suLS*`\u001b>#U\u000bT#`\u0003R#&+\u0013\"V)\u0016{f*Q'F\u0015\u0011q\u0015-\\3\u000b\u0015\u0005#HO]5ckR,7O\u0003\u0003vi&d'b\u00016be*y\u0011\t\u001e;sS\n,H/Z:%\u001d\u0006lWMC\u000bL\u001fRc\u0015JT0K'~ku\nR+M\u000b~s\u0015)T#\u000b1\u001d,GoS(U\u0019&suLS*`\u001b>#U\u000bT#`\u001d\u0006kUIC\u0002M\u001f\u001eSa\u0001T8hO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0015\u0011L\u0017m\u001a8pgRL7MC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*iQ*\u0011(J\r\u0016\u001bFk\u0018)B)\"Sq!T#U\u0003&seIC\tN\u000bR\u000b\u0015J\u0014$`%\u0016\u001bv*\u0016*D\u000bNS1\u0004V%U\u0019\u0016{6j\u0014+M\u0013:{&*\u0011,B'\u000e\u0013\u0016\n\u0015+`\u0019&\u0013%B\b+J)2+ulS(U\u0019&suLS!W\u0003N\u001b%+\u0013)U?N#F\tT%C\u0015M\u0019\u0007.Z2l\u0003R$(/\u001b2vi\u00164\u0016\r\\;f\u0015\u001da\u0017N\u0019:befTAAR5mK*\u0011\u0011n\u001c\u0006\tKb\u0004Xm\u0019;fI*i\u0011\r\u001e;sS\n,H/\u001a(b[\u0016TqAQ8pY\u0016\fgN\u0003\rd_BL(j\u001d$jY\u0016\u001chI]8n\t&\u0014Xm\u0019;pefT1\u0001Z5s\u0015MyW\u000f\u001e9vi2K'M]1ss*\u001b\b+\u0019;i\u0015\u0011)f.\u001b;\u000b1\r|\u0007/\u001f&t\r&dWm\u001d$s_6d\u0015N\u0019:be&,7OC\u0005mS\n\u0014\u0018M]5fg*!A*[:u\u0015I\u0019w\u000e]=Kg\u001aKG.Z:Ge>l',\u001b9\u000b\t\u0019LG.\u001a\u0006\u000bO\u0016$(*\u0019:GS2,'\u0002D2mCN\u001cXm\u001d*p_R\u001c(b\u0003,jeR,\u0018\r\u001c$jY\u0016T1A\u001e4t\u0015\u001dQ\u0017M\u001d(b[\u0016TQcZ3u\u0017>$H.\u001b8Kg6{G-\u001e7f\u001d\u0006lWM\u0003\rhKRl\u0015M\\5gKN$hI]8n\t&\u0014Xm\u0019;pefT\u0001\"T1oS\u001a,7\u000f\u001e\u0006\u0013O\u0016$X*\u00198jM\u0016\u001cHO\u0012:p[*\u000b'OC\u000fhKRl\u0015M\\5gKN$hI]8n\u0015\u0006\u0014xJ\u001d#je\u0016\u001cGo\u001c:z\u0015-:W\r^'b]&4Wm\u001d;NC&t\u0017\t\u001e;sS\n,H/Z:Ge>l'*\u0019:Pe\u0012K'/Z2u_JL(\u0002E4fiN+xmZ3ti\u0016$\u0007+\u0019;i\u0015\u0011\u0001\u0018\r\u001e5\u000b3%\u001c8j\u001c;mS:T\u0015M^1tGJL\u0007\u000f\u001e'jEJ\f'/\u001f\u0006\u001dSN\\u\u000e\u001e7j]*\u000bg/Y:de&\u0004Ho\u0015;e\u0019&\u0014'/\u0019:z\u0015=!(/\u0019<feN,\u0017I]2iSZ,'B\u0003)s_B,'\u000f^5fg*\tr-\u001a;Qe>\u0004XM\u001d;z\u001fJ4\u0015-\u001b7\u000b\u0011A\u0014x\u000e\u001d(b[\u0016\u0004 A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0004\t\u000bA9\u0001\u0004\u0001\u0006\u0003!!QA\u0001\u0003\u0005\u0011\u0013)!\u0001\"\u0003\t\b\u0015\u0011A\u0001\u0002E\u0007\u000b\t!Y\u0001C\u0004\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\r!i\u0001c\u0003\r\u0001\u0015\u0011AA\u0002E\b\u000b\u0005A!\"\u0002\u0002\u0005\u0011!UQA\u0001C\t\u0011-)!\u0001B\u0005\t\u0018\u0015\u0019A1\u0003E\n\u0019\u0001)!\u0001b\u0005\t\u0014\u0015\u0011A\u0001\u0002E\u0011\u000b\r!1\u0002\u0003\t\r\u0001\u0015\u0019AQ\u0001\u0005\u0013\u0019\u0001)!\u0001B\u0006\t!\u0015\u0019AQ\u0001\u0005\u0015\u0019\u0001)1\u0001\"\u0002\t,1\u0001QA\u0001C\u0006\u0011W)!\u0001B\u0005\t2\u0015\u0019AQ\u0004\u0005\u0019\u0019\u0001)!\u0001\"\b\t1\u0015\u0019AA\u0002E\u001b\u0019\u0001)!\u0001\u0002\u0004\t6\u0015\u0011AA\u0002\u0005\u0007\u000b\r!Y\u0001C\u0010\r\u0001\u0015\u0011A1\u0002\u0005 \t\r\fABA\r\u0003\u000b\u0005A1!L\u0006\u0005CRA2!\t\u0002\u0006\u0003!\u001dQk\u0001\u0003\u0006\u0007\u0011\u0019\u0011\"\u0001\u0005\u0006[-!\u0011\r\u0002\r\u0006C\t)\u0011\u0001C\u0004V\u0007\u0011)1\u0001B\u0003\n\u0003!=Qf\u0004\u0003d)aA\u0011EA\u0003\u0002\u0011\u000f)6\u0001C\u0003\u0004\t!I\u0011\u0001C\u0003\u000e\u0007\u0011E\u0011\"\u0001\u0005\u0006[A!\u0011\r\u0002\r\nC\u001d)\u0011\u0001\u0003\u0006\u0011\u0019U\u0019Q!\u0001\u0005\u000b\u0019\u0003)6\u0001B\u0003\u0004\t%I\u0011\u0001#\u0006.\u0017\u0011\tG\u0003'\u0007\"\u0005\u0015\t\u0001rA+\u0004\t\u0015\u0019A\u0011D\u0005\u0002\u0011\u0015i3\u0002B1\u001515\t#!B\u0001\t\bU\u001bA!B\u0002\u0005\u001b%\t\u0001\"B\u0017\f\t\u0005$\u00024D\u0011\u0003\u000b\u0005A9!V\u0002\u0005\u000b\r!Y\"C\u0001\t\u000b5ZA!1\u0007\u0019\u001d\u0005\u0012Q!\u0001E\u0004+\u000e!Qa\u0001\u0003\u000f\u0013\u0005AQ!L\u0006\u0005\u00034Aj\"\t\u0002\u0006\u0003!\u001dQk\u0001\u0003\u0006\u0007\u0011u\u0011\"\u0001\u0005\u0006[\u0019\"\u0011\u0001G\b\u001e\u000e\u0011\u0001\u0001rD\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001;\u001b!\u0001\u0001C\t\u000e\u0005\u0015\t\u0001r\u0001)\u0004\u0002u5A\u0001\u0001E\u0012\u001b\t)\u0011\u0001C\u0004Q\u0007\u0005\t#!B\u0001\t\u0019E\u001b\u0011\u0002B\b\n\u0003\u0011\u0005Q\"\u0001E\r\u001b\u0005AQ!D\u0001\t\u00105fB!\u0001M\u0013;\u001b!\u0001\u0001C\n\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u5A\u0001\u0001E\u0014\u001b\t)\u0011\u0001c\u0002Q\u0007\u0003\t#!B\u0001\t\u001bE\u001bq\u0001\"\n\n\u0003\u0011\u0001Q\"\u0001E\r\u001b\u0005AQ!,\u0011\u0005\ba%RT\u0003\u0003\u0001\u0011Uia!B\u0001\t\u001c%\u0019\u0011BA\u0003\u0002\u0011\u000f\u00016\u0001AO\u0007\t\u0001A9#\u0004\u0002\u0006\u0003!\u001d\u0001k!\u0001\"\u0005\u0015\t\u0001\"D)\u0004\u000f\u0011%\u0012\"\u0001\u0003\u0001\u001b\u0005Aa\"D\u0001\t\u000b5fB!\u0001\r\u0017;\u001b!\u0001\u0001#\f\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u5A\u0001\u0001E\u0014\u001b\t)\u0011\u0001c\u0002Q\u0007\u0003\t#!B\u0001\t\u001bE\u001bq\u0001\u0002\f\n\u0003\u0011\u0001Q\"\u0001E\r\u001b\u0005AQ!l\u0011\u0005\ba9RT\u0003\u0003\u0001\u0011_ia!B\u0001\t\u001c%\u0019\u0011BA\u0003\u0002\u0011=\u00016\u0001AO\u0007\t\u0001A\u0011$\u0004\u0002\u0006\u0003!\u001d\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0004G\u0001#\u000e9AaF\u0005\u0002\u0011?i\u0011\u0001\u0003\b\u000e\u0003!)Q\u0006\u0006C\u00041gij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011\u000fa\t!U\u0002\u0006\tgI\u0011\u0001C\u0003\u000e\u0003!eQ\u0006\u0006\u0003\u00021iij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011Aa\t!U\u0002\u0006\tiI\u0011\u0001#\t\u000e\u0003!eQ\u0006\u0006\u0003\u00021mij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011Aa\t!U\u0002\u0006\tmI\u0011\u0001#\t\u000e\u0003!eQ\u0006\u0006\u0003\u00021oij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011Aa\t!U\u0002\u0006\toI\u0011\u0001#\t\u000e\u0003!eQ\u0006\u0006\u0003\u00021qij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011\u001ba\t!U\u0002\u0006\tqI\u0011\u0001C\t\u000e\u0003!eQ\u0006\u0006\u0003\u00021sij\u0001\u0002\u0001\t;5\u0011Q!\u0001E\u0004!\u000e\u0001\u0011eA\u0003\u0002\u0011\u000fa\t!U\u0002\u0006\tsI\u0011\u0001C\u0003\u000e\u0003!)Qf\u0005C\u00041wij\u0001\u0002\u0001\t 5\u0011Q!\u0001E\f!\u000e\u0001\u0011EA\u0003\u0002\u00111\t6!\u0002C\u001e\u0013\u0005!\t!D\u0001\t\u001a5\u001aBq\u0001\r\u001f;\u001b!\u0001\u0001c\b\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001\u0005\u0012Q!\u0001\u0005\r#\u000e)AAH\u0005\u0002\t\u0003i\u0011\u0001#\u0007.:\u0011\r\u0001THO\u0007\t\u0001Ai#\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rE\u0007\u0003\u000b\u0005A9\u0001UB\u0001C\t)\u0011\u0001C\u0007R\u0007\u001d!i$C\u0001\u0005\u00015\t\u0001\u0012D\u0007\u0002\u0011\u0015i\u0003\u0004B\u0001\u0016\u0005\u0015\t\u00012\u0005M ;\u001b!\u0001\u0001\u0003\u0011\u000e\u0005\u0015\t\u0001r\u0001)\u0004\u0002\u0005\u0012Q!\u0001E\u0004#\u000e9AqH\u0005\u0002\u0011\u0015i\u0011\u0001\u0003\n\u000e\u0003!)Q\u0007\u0001"})
public final class LibraryUtils
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final String KOTLIN_JS_MODULE_NAME = "Kotlin-JS-Module-Name";
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    private static String TITLE_KOTLIN_JAVASCRIPT_LIB;
    private static final String JS_EXT = ".js";
    private static final String METAINF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String METAINF_RESOURCES = "META-INF/resources/";
    private static final Attributes.Name KOTLIN_JS_MODULE_ATTRIBUTE_NAME;
    public static final LibraryUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(LibraryUtils.class);
        new LibraryUtils();
    }

    @NotNull
    public final String getKOTLIN_JS_MODULE_NAME() {
        return KOTLIN_JS_MODULE_NAME;
    }

    @platformStatic
    @Nullable
    public static final VirtualFile getJarFile(@JetValueParameter(name="classesRoots") @NotNull List<? extends VirtualFile> classesRoots, @JetValueParameter(name="jarName") @NotNull String jarName) {
        Intrinsics.checkParameterIsNotNull(classesRoots, "classesRoots");
        Intrinsics.checkParameterIsNotNull(jarName, "jarName");
        for (VirtualFile virtualFile : classesRoots) {
            if (!Intrinsics.areEqual(virtualFile.getName(), jarName)) continue;
            return virtualFile;
        }
        return null;
    }

    @platformStatic
    @Nullable
    public static final String getKotlinJsModuleName(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes attributes = INSTANCE$.getManifestMainAttributesFromJarOrDirectory(library);
        return attributes != null ? attributes.getValue(KOTLIN_JS_MODULE_ATTRIBUTE_NAME) : null;
    }

    @platformStatic
    public static final boolean isKotlinJavascriptLibrary(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.SPECIFICATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.SPECIFICATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_LIB, name);
    }

    @platformStatic
    public static final boolean isKotlinJavascriptStdLibrary(@JetValueParameter(name="library") @NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    @platformStatic
    public static final void copyJsFilesFromLibraries(@JetValueParameter(name="libraries") @NotNull List<? extends String> libraries, @JetValueParameter(name="outputLibraryJsPath") @NotNull String outputLibraryJsPath) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String string : libraries) {
            File file = new File(string);
            boolean bl = file.exists();
            if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
                String string2 = "Library " + string + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (file.isDirectory()) {
                INSTANCE$.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE$.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    private final void copyJsFilesFromDirectory(@JetValueParameter(name="dir") File dir, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, outputLibraryJsPath){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ File $dir;
            final /* synthetic */ String $outputLibraryJsPath;

            static {
                $kotlinClass = Reflection.createKotlinClass(copyJsFilesFromDirectory.1.class);
            }

            public boolean process(@JetValueParameter(name="file") @NotNull File file) {
                boolean bl;
                boolean bl2;
                Intrinsics.checkParameterIsNotNull(file, "file");
                String relativePath = FileUtil.getRelativePath(this.$dir, file);
                boolean bl3 = bl2 = relativePath != null;
                if (KotlinPackage.getASSERTIONS_ENABLED() && !bl2) {
                    String string = "relativePath should not be null " + this.$dir + " " + file;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (file.isFile()) {
                    String string = relativePath;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    bl = KotlinPackage.endsWith(string, LibraryUtils.access$getJS_EXT$1(LibraryUtils.INSTANCE$));
                } else {
                    bl = false;
                }
                if (bl) {
                    String string = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull(string, "relativePath");
                    relativePath = LibraryUtils.access$getSuggestedPath$2(LibraryUtils.INSTANCE$, string);
                    if (relativePath == null) {
                        return true;
                    }
                    try {
                        File copyFile = new File(this.$outputLibraryJsPath, relativePath);
                        FileUtil.copy(file, copyFile);
                    }
                    catch (IOException ex) {
                        LibraryUtils.access$getLOG$0(LibraryUtils.INSTANCE$).error("Could not copy " + relativePath + " from " + this.$dir + ": " + ex.getMessage());
                    }
                }
                return true;
            }
            {
                this.$dir = $captured_local_variable$0;
                this.$outputLibraryJsPath = $captured_local_variable$1;
            }
        });
    }

    private final void copyJsFilesFromZip(@JetValueParameter(name="file") File file, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        try {
            this.traverseArchive(file, outputLibraryJsPath);
        }
        catch (IOException ex) {
            LOG.error("Could not extract javascript files from  " + file.getName() + ": " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void traverseArchive(@JetValueParameter(name="file") File file, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) throws IOException {
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (!(!entry.isDirectory() ? KotlinPackage.endsWith(entryName, JS_EXT) : false)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                String relativePath = this.getSuggestedPath(string);
                if (relativePath == null) continue;
                InputStream stream2 = zipFile.getInputStream(entry);
                String content = FileUtil.loadTextAndClose(stream2);
                File outputFile = new File(outputLibraryJsPath, relativePath);
                FileUtil.writeToFile(outputFile, content);
            }
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(@JetValueParameter(name="path") String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName(path);
        if (KotlinPackage.startsWith(systemIndependentPath, METAINF)) {
            if (KotlinPackage.startsWith(systemIndependentPath, METAINF_RESOURCES)) {
                return KotlinPackage.substring(path, METAINF_RESOURCES.length());
            }
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(@JetValueParameter(name="library") File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(library);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(@JetValueParameter(name="library") File library) {
        boolean bl = !(!library.canRead()) ? !library.isDirectory() : true;
        if (bl) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest = new Manifest(inputStream);
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        Manifest manifest = this.getManifestFromJarOrDirectory(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(@JetValueParameter(name="library") File library, @JetValueParameter(name="expected") String expected, @JetValueParameter(name="attributeName") Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value != null ? Intrinsics.areEqual(value, expected) : false;
    }

    private final String getPropertyOrFail(@JetValueParameter(name="$receiver") Properties $receiver, @JetValueParameter(name="propName") String propName) {
        String value = $receiver.getProperty(propName);
        if (value == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $receiver.list(new PrintStream(bytes));
            LOG.error(propName + " not found." + "\n" + " " + bytes);
        }
        String string = value;
        Intrinsics.checkExpressionValueIsNotNull(string, "value");
        return string;
    }

    LibraryUtils() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        KOTLIN_JS_MODULE_NAME = KOTLIN_JS_MODULE_NAME;
        JS_EXT = JS_EXT;
        METAINF = METAINF;
        MANIFEST_PATH = METAINF + "MANIFEST.MF";
        METAINF_RESOURCES = METAINF + "resources/";
        KOTLIN_JS_MODULE_ATTRIBUTE_NAME = new Attributes.Name(KOTLIN_JS_MODULE_NAME);
        String jsStdLib = "";
        String jsLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jsStdLib = this.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
                jsLib = this.getPropertyOrFail(properties2, "manifest.spec.title.kotlin.javascript.lib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
        TITLE_KOTLIN_JAVASCRIPT_LIB = jsLib;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$0(@JetValueParameter(name="$this", type="?") LibraryUtils $this) {
        LibraryUtils libraryUtils = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String access$getJS_EXT$1(@JetValueParameter(name="$this", type="?") LibraryUtils $this) {
        LibraryUtils libraryUtils = $this;
        return JS_EXT;
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath$2(@JetValueParameter(name="$this", type="?") LibraryUtils $this, @JetValueParameter(name="path") @NotNull String path) {
        return $this.getSuggestedPath(path);
    }
}

