/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RemovableSlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMap;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapKey;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class Slices {
    private static final Logger LOG = Logger.getInstance(Slices.class);
    public static final RewritePolicy ONLY_REWRITE_TO_EQUAL = new RewritePolicy(){

        @Override
        public <K> boolean rewriteProcessingNeeded(K key) {
            return true;
        }

        @Override
        public <K, V> boolean processRewrite(WritableSlice<K, V> slice, K key, V oldValue, V newValue) {
            if (!(oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue))) {
                LOG.error("Rewrite at slice " + slice + " key: " + key + " old value: " + oldValue + '@' + System.identityHashCode(oldValue) + " new value: " + newValue + '@' + System.identityHashCode(newValue));
            }
            return true;
        }
    };

    private Slices() {
    }

    public static <K, V> SliceBuilder<K, V> sliceBuilder() {
        return new SliceBuilder(ONLY_REWRITE_TO_EQUAL);
    }

    public static <K, V> WritableSlice<K, V> createSimpleSlice() {
        return new BasicWritableSlice(ONLY_REWRITE_TO_EQUAL);
    }

    public static <K, V> WritableSlice<K, V> createCollectiveSlice() {
        return new BasicWritableSlice(ONLY_REWRITE_TO_EQUAL, true);
    }

    public static <K> WritableSlice<K, Boolean> createSimpleSetSlice() {
        return Slices.createRemovableSetSlice();
    }

    public static <K> WritableSlice<K, Boolean> createCollectiveSetSlice() {
        return new SetSlice(RewritePolicy.DO_NOTHING, true);
    }

    public static <K> RemovableSlice<K, Boolean> createRemovableSetSlice() {
        return new SetSlice(RewritePolicy.DO_NOTHING, false);
    }

    public static class SetSlice<K>
    extends BasicRemovableSlice<K, Boolean> {
        protected SetSlice(RewritePolicy rewritePolicy) {
            this(rewritePolicy, false);
        }

        protected SetSlice(RewritePolicy rewritePolicy, boolean collective) {
            super(rewritePolicy, collective);
        }

        @Override
        public Boolean computeValue(SlicedMap map, K key, Boolean value, boolean valueNotFound) {
            Boolean result2 = super.computeValue(map, key, value, valueNotFound);
            return result2 != null ? result2 : false;
        }
    }

    public static class SliceWithOpposite<K, V>
    extends BasicRemovableSlice<K, V> {
        private final WritableSlice<? super V, ? super K> opposite;
        private final KeyNormalizer<K> keyNormalizer;

        public SliceWithOpposite(RewritePolicy rewritePolicy, WritableSlice<? super V, ? super K> opposite, KeyNormalizer<K> keyNormalizer) {
            super(rewritePolicy);
            this.opposite = opposite;
            this.keyNormalizer = keyNormalizer;
        }

        @Override
        public void afterPut(MutableSlicedMap map, K key, V value) {
            if (this.opposite != null) {
                map.put(this.opposite, value, key);
            }
        }

        @Override
        public SlicedMapKey<K, V> makeKey(K key) {
            if (this.keyNormalizer == null) {
                return super.makeKey(key);
            }
            return super.makeKey(this.keyNormalizer.normalize(key));
        }
    }

    public static class BasicRemovableSlice<K, V>
    extends BasicWritableSlice<K, V>
    implements RemovableSlice<K, V> {
        protected BasicRemovableSlice(RewritePolicy rewritePolicy) {
            super(rewritePolicy);
        }

        protected BasicRemovableSlice(RewritePolicy rewritePolicy, boolean isCollective) {
            super(rewritePolicy, isCollective);
        }
    }

    public static class SliceBuilder<K, V> {
        private V defaultValue = null;
        private List<ReadOnlySlice<K, V>> furtherLookupSlices = null;
        private WritableSlice<? super V, ? super K> opposite = null;
        private KeyNormalizer<K> keyNormalizer = null;
        private final RewritePolicy rewritePolicy;
        private String debugName;

        private SliceBuilder(RewritePolicy rewritePolicy) {
            this.rewritePolicy = rewritePolicy;
        }

        public SliceBuilder<K, V> setDefaultValue(V defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public SliceBuilder<K, V> setFurtherLookupSlices(ReadOnlySlice<K, V> ... furtherLookupSlices) {
            this.furtherLookupSlices = Arrays.asList(furtherLookupSlices);
            return this;
        }

        public SliceBuilder<K, V> setOpposite(WritableSlice<? super V, ? super K> opposite) {
            this.opposite = opposite;
            return this;
        }

        public SliceBuilder<K, V> setDebugName(@NotNull String debugName) {
            if (debugName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/util/slicedMap/Slices$SliceBuilder", "setDebugName"));
            }
            this.debugName = debugName;
            return this;
        }

        public SliceBuilder<K, V> setKeyNormalizer(KeyNormalizer<K> keyNormalizer) {
            this.keyNormalizer = keyNormalizer;
            return this;
        }

        public RemovableSlice<K, V> build() {
            SliceWithOpposite<K, V> result2 = this.doBuild();
            if (this.debugName != null) {
                result2.setDebugName(this.debugName);
            }
            return result2;
        }

        private SliceWithOpposite<K, V> doBuild() {
            if (this.defaultValue != null) {
                return new SliceWithOpposite<K, V>(this.rewritePolicy, this.opposite, this.keyNormalizer){

                    @Override
                    public V computeValue(SlicedMap map, K key, V value, boolean valueNotFound) {
                        if (valueNotFound) {
                            return SliceBuilder.this.defaultValue;
                        }
                        return super.computeValue(map, key, value, false);
                    }
                };
            }
            if (this.furtherLookupSlices != null) {
                return new SliceWithOpposite<K, V>(this.rewritePolicy, this.opposite, this.keyNormalizer){

                    @Override
                    public V computeValue(SlicedMap map, K key, V value, boolean valueNotFound) {
                        if (valueNotFound) {
                            for (ReadOnlySlice slice : SliceBuilder.this.furtherLookupSlices) {
                                Object v = map.get(slice, key);
                                if (v == null) continue;
                                return v;
                            }
                            return SliceBuilder.this.defaultValue;
                        }
                        return super.computeValue(map, key, value, false);
                    }
                };
            }
            return new SliceWithOpposite<K, V>(this.rewritePolicy, this.opposite, this.keyNormalizer);
        }
    }

    public static interface KeyNormalizer<K> {
        public static final KeyNormalizer DO_NOTHING = new KeyNormalizer<Object>(){

            @Override
            public Object normalize(Object key) {
                return key;
            }
        };

        public K normalize(K var1);
    }
}

