/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.resolveUtil;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinSyntheticClass(abiVersion=20, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ResolveUtilPackage$checkTraitRequirements$8f29cd7d {
    public static final void checkTraitRequirements(@JetValueParameter(name="c") @NotNull Map<JetClassOrObject, ? extends ClassDescriptorWithResolutionScopes> c, @JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        for (Map.Entry<JetClassOrObject, ? extends ClassDescriptorWithResolutionScopes> entry : c.entrySet()) {
            JetClassOrObject classOrObject = KotlinPackage.component1(entry);
            ClassDescriptorWithResolutionScopes descriptor = KotlinPackage.component2(entry);
            if (DescriptorUtils.isTrait(descriptor)) continue;
            Set satisfiedRequirements = ResolveUtilPackage$checkTraitRequirements$8f29cd7d.getSuperClassesReachableByClassInheritance$default(descriptor, null, 2);
            for (ClassDescriptor superTrait : ResolveUtilPackage$checkTraitRequirements$8f29cd7d.getAllSuperTraits(descriptor)) {
                for (JetType traitSupertype : superTrait.getDefaultType().getConstructor().getSupertypes()) {
                    ClassifierDescriptor traitSuperClass = traitSupertype.getConstructor().getDeclarationDescriptor();
                    if (!(DescriptorUtils.isClass(traitSuperClass) ? satisfiedRequirements.contains(traitSuperClass) ^ true : false)) continue;
                    ClassifierDescriptor classifierDescriptor = traitSuperClass;
                    if (classifierDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.ClassifierDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    trace.report(Errors.UNMET_TRAIT_REQUIREMENT.on((JetNamedDeclaration)((PsiElement)classOrObject), superTrait, (ClassDescriptor)classifierDescriptor));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassDescriptor> getAllSuperTraits(@JetValueParameter(name="descriptor") @NotNull ClassDescriptor descriptor) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Iterable iterable2 = iterable = (Iterable)TypeUtils.getAllSupertypes(descriptor.getDefaultType());
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            void supertype;
            JetType jetType = (JetType)t;
            Collection collection2 = collection;
            ClassifierDescriptor classifierDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            collection2.add(classifierDescriptor);
        }
        iterable2 = iterable = (Iterable)((ArrayList)collection);
        collection = new ArrayList();
        for (Object t : iterable2) {
            ClassifierDescriptor superClass = (ClassifierDescriptor)t;
            if (!DescriptorUtils.isTrait(superClass)) continue;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @NotNull
    public static final Set<ClassDescriptor> getSuperClassesReachableByClassInheritance(@JetValueParameter(name="descriptor") @NotNull ClassDescriptor descriptor, @JetValueParameter(name="result") @NotNull Set<ClassDescriptor> result2) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        ClassDescriptor superClass = ResolveUtilPackage$checkTraitRequirements$8f29cd7d.getSuperClass(descriptor);
        result2.add(superClass);
        if (!KotlinBuiltIns.isAny(superClass)) {
            ResolveUtilPackage$checkTraitRequirements$8f29cd7d.getSuperClassesReachableByClassInheritance(superClass, result2);
        }
        return result2;
    }

    public static Set getSuperClassesReachableByClassInheritance$default(ClassDescriptor classDescriptor, Set set, int n) {
        if ((n & 2) != 0) {
            set = KotlinPackage.hashSetOf(new ClassDescriptor[0]);
        }
        return ResolveUtilPackage$checkTraitRequirements$8f29cd7d.getSuperClassesReachableByClassInheritance(classDescriptor, set);
    }

    @NotNull
    public static final ClassDescriptor getSuperClass(@JetValueParameter(name="descriptor") @NotNull ClassDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        for (JetType supertype : descriptor.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier = supertype.getConstructor().getDeclarationDescriptor();
            if (!(!DescriptorUtils.isClass(superClassifier) ? DescriptorUtils.isEnumClass(superClassifier) : true)) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.ClassifierDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        ClassDescriptor classDescriptor = KotlinBuiltIns.getInstance().getAny();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "KotlinBuiltIns.getInstance().getAny()");
        return classDescriptor;
    }
}

