/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.lang.ref.WeakReference;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"[\u0006)!\u0012J\u001c7j]\u0016\u001c\u0005.Z2lKJ<&/\u00199qKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0015\u0019\u0017\r\u001c7t\u0015!\u0019\u0007.Z2lKJ\u001c(bC\"bY2\u001c\u0005.Z2lKJTa\u0001P5oSRt$\"D2iK\u000e\\WM]:DC\u000eDWMC\u0007XK\u0006\\'+\u001a4fe\u0016t7-\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'b\u0001:fM*QQ*\u001e;bE2,W*\u00199\u000b+\u0011+7\r\\1sCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015\u00051%BE\"bY2\f'\r\\3EKN\u001c'/\u001b9u_JTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(BC4fi\u000eCWmY6fe*QA-Z:de&\u0004Ho\u001c:\u000b1MKW\u000e\u001d7f\rVt7\r^5p]\u0012+7o\u0019:jaR|'On\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0011Aa!\u0002\u0002\u0005\n!5Qa\u0001\u0003\u0006\u0011\u0015a\u0001!B\u0001\t\u0004\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001B\u0001\t\u0011\u0015\u0019Aa\u0002E\b\u0019\u0001)!\u0001B\u0003\t\u000b\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)!\u0001\u0002\u0002\t\u0017\u0015\u0019A!\u0003E\u000b\u0019\u0001)!\u0001\u0002\u0002\t\u0018\u0015\u0019AA\u0003\u0005\r\u0019\u0001)1\u0001\u0002\u0004\t\u001a1\u0001QA\u0001\u0003\n\u0011+)!\u0001\u0002\u0006\t\u0019\u0015\u0019Aa\u0002\u0005\u000f\u0019\u0001)!\u0001\"\u0002\t\b\u0015\u0011Aa\u0002\u0005\u000f\t\ra1!\u0007\u0002\u0006\u0003!\u001dQ\u0006\u0007\u0003B\u001aa%\u0011eD\u0003\u0002\u0011\u0017I1\"\u0003\u0006\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001r\u0001G\u0001+\u000e!Qa\u0001C\u0005\u0013\u0005A\u0001\",\u0015\u0005\u0017E1A\u0001\u0001E\t+\r)\u0011\u0001#\u0005\r\u0002aMQt\u0003\u0003\u0001\u0011)iq!B\u0001\t\u0014%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0006\u000e\u0005\u0015\t\u0001R\u0003)\u0004\u0002\u0005\u0012Q!\u0001\u0005\f#\u000e9A1C\u0005\u0002\t\u0001i\u0011\u0001c\u0006\u000e\u0003!aQf\u0005\u0003\u000215ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\r!\u000e\u0001\u0011EA\u0003\u0002\u0011\u000f\t6!\u0002\u0003\u000e\u0013\u0005AQ\"D\u0001\t\u001cUZQA\u0003\u0003d\u0002a!\u0011EA\u0003\u0002\u0011\r\t6a\u0001\u0003\u0005\u0013\u0005!\u0001\u0001"})
public final class InlineCheckerWrapper
implements KObject,
CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    static {
        $kotlinClass = Reflection.createKotlinClass(InlineCheckerWrapper.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<F> resolvedCall, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        if (((ResolutionContext)context2).isAnnotationContext) {
            return;
        }
        DeclarationDescriptor parentDescriptor = ((ResolutionContext)context2).scope.getContainingDeclaration();
        while (parentDescriptor != null) {
            DeclarationDescriptor descriptor;
            if (parentDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (descriptor instanceof SimpleFunctionDescriptor ? ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline() : false) {
                CallChecker checker = this.getChecker((SimpleFunctionDescriptor)descriptor);
                checker.check(resolvedCall, context2);
            }
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            parentDescriptor = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        }
    }

    private final CallChecker getChecker(@JetValueParameter(name="descriptor") SimpleFunctionDescriptor descriptor) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map = (Map)KotlinPackage.hashMapOf(new Pair[0]);
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference3 = map;
        if (weakReference3.containsKey(descriptor)) {
            object = weakReference3.get(descriptor);
        } else {
            InlineChecker inlineChecker = new InlineChecker(descriptor);
            weakReference3.put(descriptor, inlineChecker);
            object = inlineChecker;
        }
        return (CallChecker)object;
    }
}

