/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public class CandidateResolver {
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    public <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context2, @NotNull ResolutionTask<D, F> task) {
        List<JetTypeProjection> jetTypeArguments;
        LinkedHashSet<ValueArgument> unmappedArguments;
        ValueArgumentsToParametersMapper.Status argumentMappingStatus;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "performResolutionForCandidateCall"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "performResolutionForCandidateCall"));
        }
        ProgressIndicatorProvider.checkCanceled();
        MutableResolvedCall candidateCall = context2.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        candidateCall.addStatus(CandidateResolver.checkReceiverTypeError(context2));
        if (ErrorUtils.isError(candidate)) {
            candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!CandidateResolver.checkOuterClassMemberIsAccessible(context2)) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility(candidateCall.getDispatchReceiver(), context2.trace.getBindingContext());
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(receiverValue, candidate, context2.scope.getContainingDeclaration());
        if (invisibleMember != null) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            context2.tracing.invisibleMember(context2.trace, invisibleMember);
        }
        if (task.checkArguments == CheckValueArgumentsMode.ENABLED && !(argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters(context2.call, context2.tracing, candidateCall, unmappedArguments = Sets.newLinkedHashSet())).isSuccess()) {
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                candidateCall.addStatus(ResolutionStatus.RECEIVER_PRESENCE_ERROR);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
        if (!CandidateResolver.checkDispatchReceiver(context2)) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
        if (!(jetTypeArguments = context2.call.getTypeArguments()).isEmpty()) {
            ArrayList<JetType> typeArguments = new ArrayList<JetType>();
            for (JetTypeProjection projection : jetTypeArguments) {
                if (projection.getProjectionKind() != JetProjectionKind.NONE) {
                    context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                    ModifiersChecker.checkIncompatibleVarianceModifiers(projection.getModifierList(), context2.trace);
                }
                JetType type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context2.scope, context2.trace, ErrorUtils.createErrorType("Star projection in a call"));
                ForceResolveUtil.forceResolveAllContents(type2);
                typeArguments.add(type2);
            }
            int expectedTypeArgumentCount = candidate.getTypeParameters().size();
            for (int index2 = jetTypeArguments.size(); index2 < expectedTypeArgumentCount; ++index2) {
                typeArguments.add(ErrorUtils.createErrorType("Explicit type argument expected for " + candidate.getTypeParameters().get(index2).getName()));
            }
            Map<TypeConstructor, TypeProjection> substitutionContext = FunctionDescriptorUtil.createSubstitutionContext((FunctionDescriptor)candidate, typeArguments);
            TypeSubstitutor substitutor = TypeSubstitutor.create(substitutionContext);
            if (expectedTypeArgumentCount != jetTypeArguments.size()) {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                context2.tracing.wrongNumberOfTypeArguments(context2.trace, expectedTypeArgumentCount);
            } else {
                CandidateResolver.checkGenericBoundsInAFunctionCall(jetTypeArguments, typeArguments, candidate, substitutor, context2.trace);
            }
            candidateCall.setResultingSubstitutor(substitutor);
        }
        if (jetTypeArguments.isEmpty() && !candidate.getTypeParameters().isEmpty()) {
            candidateCall.addStatus(this.inferTypeArguments(context2));
        } else {
            candidateCall.addStatus(this.checkAllValueArguments(context2, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).status);
        }
        CandidateResolver.checkAbstractAndSuper(context2);
    }

    private static boolean checkDispatchReceiver(@NotNull CallCandidateResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkDispatchReceiver"));
        }
        MutableResolvedCall candidateCall = context2.candidateCall;
        Object candidateDescriptor = candidateCall.getCandidateDescriptor();
        ReceiverValue dispatchReceiver = candidateCall.getDispatchReceiver();
        if (dispatchReceiver.exists()) {
            ClassDescriptor nestedClass = null;
            if (candidateDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(candidateDescriptor.getContainingDeclaration())) {
                nestedClass = (ClassDescriptor)candidateDescriptor.getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedDescriptor();
            }
            if (nestedClass != null) {
                context2.tracing.nestedClassAccessViaInstanceReference(context2.trace, nestedClass, candidateCall.getExplicitReceiverKind());
                return false;
            }
        }
        assert (dispatchReceiver.exists() == (candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null)) : "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
        return true;
    }

    private static boolean checkOuterClassMemberIsAccessible(@NotNull CallCandidateResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkOuterClassMemberIsAccessible"));
        }
        if (context2.call.getExplicitReceiver().exists() || context2.call.getDispatchReceiver().exists()) {
            return true;
        }
        ClassDescriptor candidateThis = CandidateResolver.getDeclaringClass(context2.candidateCall.getCandidateDescriptor());
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context2.scope, context2.trace, context2.call.getCallElement(), candidateThis);
    }

    private static <D extends CallableDescriptor> void checkAbstractAndSuper(@NotNull CallCandidateResolutionContext<D> context2) {
        JetSuperExpression superExtensionReceiver;
        JetSuperExpression superDispatchReceiver;
        Modality modality;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAbstractAndSuper"));
        }
        MutableResolvedCall candidateCall = context2.candidateCall;
        Object descriptor = candidateCall.getCandidateDescriptor();
        JetExpression expression = context2.candidateCall.getCall().getCalleeExpression();
        if (expression instanceof JetSimpleNameExpression && descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
            context2.tracing.instantiationOfAbstractClass(context2.trace);
        }
        if ((superDispatchReceiver = CandidateResolver.getReceiverSuper(candidateCall.getDispatchReceiver())) != null && descriptor instanceof MemberDescriptor && ((MemberDescriptor)descriptor).getModality() == Modality.ABSTRACT) {
            context2.tracing.abstractSuperCall(context2.trace);
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
        if ((superExtensionReceiver = CandidateResolver.getReceiverSuper(candidateCall.getExtensionReceiver())) != null) {
            context2.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on(superExtensionReceiver, superExtensionReceiver.getText()));
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
    }

    @Nullable
    private static JetSuperExpression getReceiverSuper(@NotNull ReceiverValue receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getReceiverSuper"));
        }
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @Nullable
    private static ClassDescriptor getDeclaringClass(@NotNull CallableDescriptor candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getDeclaringClass"));
        }
        ReceiverParameterDescriptor expectedThis = candidate.getDispatchReceiverParameter();
        if (expectedThis == null) {
            return null;
        }
        DeclarationDescriptor descriptor = expectedThis.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
    }

    public <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiteralsForCall(CallCandidateResolutionContext<D> context2) {
        MutableResolvedCall resolvedCall = context2.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        if (constraintSystem == null) {
            return;
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                this.addConstraintForFunctionLiteral(valueArgument, valueParameterDescriptor, constraintSystem, context2);
            }
        }
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
    }

    private <D extends CallableDescriptor> void addConstraintForFunctionLiteral(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<D> context2) {
        boolean hasExpectedReturnType;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        if (!ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context2)) {
            return;
        }
        JetFunctionLiteralExpression functionLiteralExpression = ArgumentTypeResolver.getFunctionLiteralArgument(argumentExpression, context2);
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetType expectedType = constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (expectedType == null || TypeUtils.isDontCarePlaceholder(expectedType)) {
            expectedType = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteralExpression, context2.scope, context2.trace, false);
        }
        if (expectedType == null || !KotlinBuiltIns.isFunctionOrExtensionFunctionType(expectedType) || CallResolverUtil.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = context2.candidateCall.getDataFlowInfoForArguments();
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfoForArguments.getInfo(valueArgument);
        boolean bl = hasExpectedReturnType = !CallResolverUtil.hasUnknownReturnType(expectedType);
        if (hasExpectedReturnType) {
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context2, "trace to resolve function literal with expected return type", argumentExpression);
            JetElement statementExpression = JetPsiUtil.getLastStatementInABlock(functionLiteralExpression.getBodyExpression());
            if (statementExpression == null) {
                return;
            }
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            JetType type2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteralExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type2, effectiveExpectedType, ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        JetType expectedTypeWithoutReturnType = hasExpectedReturnType ? CallResolverUtil.replaceReturnTypeByUnknown(expectedType) : expectedType;
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetType type3 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteralExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
        constraintSystem.addSubtypeConstraint(type3, effectiveExpectedType, ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
    }

    private <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(CallCandidateResolutionContext<D> context2) {
        MutableResolvedCall candidateCall = context2.candidateCall;
        final Object candidate = candidateCall.getCandidateDescriptor();
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
        LinkedHashMap<TypeParameterDescriptor, Variance> typeVariables = Maps.newLinkedHashMap();
        for (TypeParameterDescriptor typeParameterDescriptor : candidateWithFreshVariables.getTypeParameters()) {
            typeVariables.put(typeParameterDescriptor, Variance.INVARIANT);
        }
        constraintSystem.registerTypeVariables(typeVariables);
        TypeSubstitutor substituteDontCare = TypeUtils.makeConstantSubstitutor(candidateWithFreshVariables.getTypeParameters(), TypeUtils.DONT_CARE);
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidateWithFreshVariables.getValueParameters().get(entry.getKey().getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, constraintSystem, context2, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            }
        }
        ReceiverValue receiverArgument = candidateCall.getExtensionReceiver();
        ReceiverParameterDescriptor receiverParameter = candidateWithFreshVariables.getExtensionReceiverParameter();
        if (receiverArgument.exists() && receiverParameter != null) {
            JetType receiverType;
            JetType jetType = receiverType = context2.candidateCall.isSafeCall() ? TypeUtils.makeNotNullable(receiverArgument.getType()) : receiverArgument.getType();
            if (receiverArgument instanceof ExpressionReceiver) {
                receiverType = CandidateResolver.updateResultTypeForSmartCasts(receiverType, ((ExpressionReceiver)receiverArgument).getExpression(), context2);
            }
            constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPositionKind.RECEIVER_POSITION.position());
        }
        ConstraintSystem constraintSystemWithRightTypeParameters = constraintSystem.substituteTypeVariables((Function1<? super TypeParameterDescriptor, ? extends TypeParameterDescriptor>)new Function1<TypeParameterDescriptor, TypeParameterDescriptor>(){

            @Override
            public TypeParameterDescriptor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                if (typeParameterDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver$1", "invoke"));
                }
                return candidate.getTypeParameters().get(typeParameterDescriptor.getIndex());
            }
        });
        candidateCall.setConstraintSystem(constraintSystemWithRightTypeParameters);
        boolean hasContradiction = constraintSystem.getStatus().hasContradiction();
        if (!hasContradiction) {
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        return ResolutionStatus.OTHER_ERROR;
    }

    private void addConstraintForValueArgument(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        JetType expectedType = substitutor.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfoForArgument = context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        CallResolutionContext newContext = (CallResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument);
        JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies);
        context2.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        JetType type2 = CandidateResolver.updateResultTypeForSmartCasts(typeInfoForCall.getType(), argumentExpression, context2.replaceDataFlowInfo(dataFlowInfoForArgument));
        constraintSystem.addSubtypeConstraint(type2, effectiveExpectedType, ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
    }

    @Nullable
    private static JetType updateResultTypeForSmartCasts(@Nullable JetType type2, @Nullable JetExpression argumentExpression, @NotNull ResolutionContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "updateResultTypeForSmartCasts"));
        }
        JetExpression deparenthesizedArgument = ArgumentTypeResolver.getLastElementDeparenthesized(argumentExpression, context2);
        if (deparenthesizedArgument == null || type2 == null) {
            return type2;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(deparenthesizedArgument, type2, context2.trace.getBindingContext());
        if (!dataFlowValue.isStableIdentifier()) {
            return type2;
        }
        Set<JetType> possibleTypes = context2.dataFlowInfo.getPossibleTypes(dataFlowValue);
        if (possibleTypes.isEmpty()) {
            return type2;
        }
        return TypeUtils.intersect(JetTypeChecker.DEFAULT, possibleTypes);
    }

    @NotNull
    private <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.checkAllValueArguments(context2, context2.candidateCall.getTrace(), resolveFunctionArgumentBodies);
        if (valueArgumentsCheckingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        return valueArgumentsCheckingResult;
    }

    @NotNull
    public <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context2, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(context2, context2.candidateCall, trace, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.status;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceivers(context2, trace));
        ValueArgumentsCheckingResult valueArgumentsCheckingResult = new ValueArgumentsCheckingResult(resultStatus, checkingResult.argumentTypes);
        if (valueArgumentsCheckingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        return valueArgumentsCheckingResult;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceivers(@NotNull CallCandidateResolutionContext<D> context2, @NotNull BindingTrace trace) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceivers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceivers"));
        }
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall candidateCall = context2.candidateCall;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiverTypeError(context2));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context2, candidateCall, trace, candidateCall.getResultingDescriptor().getExtensionReceiverParameter(), candidateCall.getExtensionReceiver(), candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context2, candidateCall, trace, candidateCall.getResultingDescriptor().getDispatchReceiverParameter(), candidateCall.getDispatchReceiver(), candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context2.call instanceof CallTransformer.CallForImplicitInvoke));
        return resultStatus;
    }

    @NotNull
    private <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(@NotNull CallResolutionContext<C> context2, @NotNull MutableResolvedCall<D> candidateCall, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetExpression expression = argument.getArgumentExpression();
                if (expression == null) continue;
                JetType expectedType = CandidateResolver.getEffectiveExpectedType(parameterDescriptor, argument);
                if (TypeUtils.dependsOnTypeParameters(expectedType, candidateCall.getCandidateDescriptor().getTypeParameters())) {
                    expectedType = TypeUtils.NO_EXPECTED_TYPE;
                }
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)((CallResolutionContext)context2.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceBindingTrace(trace)).replaceExpectedType(expectedType);
                JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                JetType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                JetType resultingType = type2;
                if (type2 == null || type2.isError() && type2 != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType)) {
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType)) {
                        JetType smartCastType = CandidateResolver.smartCastValueArgumentTypeIfPossible(expression, expectedType, type2, newContext);
                        if (smartCastType == null) {
                            resultStatus = ResolutionStatus.OTHER_ERROR;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCastType;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                }
                argumentTypes.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        ValueArgumentsCheckingResult valueArgumentsCheckingResult = new ValueArgumentsCheckingResult(resultStatus, argumentTypes);
        if (valueArgumentsCheckingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        return valueArgumentsCheckingResult;
    }

    @Nullable
    private static JetType smartCastValueArgumentTypeIfPossible(@NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull JetType actualType, @NotNull ResolutionContext<?> context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "smartCastValueArgumentTypeIfPossible"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "smartCastValueArgumentTypeIfPossible"));
        }
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "smartCastValueArgumentTypeIfPossible"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "smartCastValueArgumentTypeIfPossible"));
        }
        ExpressionReceiver receiverToCast = new ExpressionReceiver(JetPsiUtil.safeDeparenthesize(expression, false), actualType);
        Collection<JetType> variants = SmartCastUtils.getSmartCastVariantsExcludingReceiver(context2.trace.getBindingContext(), context2.dataFlowInfo, receiverToCast);
        for (JetType possibleType : variants) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiverTypeError(@NotNull CallCandidateResolutionContext<D> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiverTypeError"));
        }
        MutableResolvedCall candidateCall = context2.candidateCall;
        Object candidateDescriptor = candidateCall.getCandidateDescriptor();
        ReceiverParameterDescriptor extensionReceiver2 = candidateDescriptor.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = candidateDescriptor.getDispatchReceiverParameter();
        ResolutionStatus status = ResolutionStatus.SUCCESS;
        if (!CallResolverUtil.isInvokeCallOnExpressionWithBothReceivers(context2.call)) {
            status = status.combine(CandidateResolver.checkReceiverTypeError(context2, extensionReceiver2, candidateCall.getExtensionReceiver()));
        }
        status = status.combine(CandidateResolver.checkReceiverTypeError(context2, dispatchReceiver, candidateCall.getDispatchReceiver()));
        return status;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiverTypeError(@NotNull CallCandidateResolutionContext<D> context2, @Nullable ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull ReceiverValue receiverArgument) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiverTypeError"));
        }
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiverTypeError"));
        }
        if (receiverParameterDescriptor == null || !receiverArgument.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        Object candidateDescriptor = context2.candidateCall.getCandidateDescriptor();
        JetType erasedReceiverType = CallResolverUtil.getErasedReceiverType(receiverParameterDescriptor, candidateDescriptor);
        boolean isSubtypeBySmartCast = SmartCastUtils.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType, context2);
        if (!isSubtypeBySmartCast) {
            return ResolutionStatus.RECEIVER_TYPE_ERROR;
        }
        return ResolutionStatus.SUCCESS;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiver(@NotNull CallCandidateResolutionContext<D> context2, @NotNull ResolvedCall<D> candidateCall, @NotNull BindingTrace trace, @Nullable ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (receiverParameter == null || !receiverArgument.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && PsiUtilPackage.isExplicitSafeCall(candidateCall.getCall());
        boolean isSubtypeBySmartCast = SmartCastUtils.isSubTypeBySmartCastIgnoringNullability(receiverArgument, receiverParameter.getType(), context2);
        if (!isSubtypeBySmartCast) {
            context2.tracing.wrongReceiverType(trace, receiverParameter, receiverArgument);
            return ResolutionStatus.OTHER_ERROR;
        }
        SmartCastUtils.recordSmartCastIfNecessary(receiverArgument, receiverParameter.getType(), context2, safeAccess);
        JetType receiverArgumentType = receiverArgument.getType();
        BindingContext bindingContext = trace.getBindingContext();
        if (!safeAccess && !receiverParameter.getType().isMarkedNullable() && receiverArgumentType.isMarkedNullable() && !SmartCastUtils.canBeSmartCast(receiverParameter, receiverArgument, bindingContext, context2.dataFlowInfo)) {
            context2.tracing.unsafeCall(trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, bindingContext);
        if (safeAccess && !context2.dataFlowInfo.getNullability(receiverValue).canBeNull()) {
            context2.tracing.unnecessarySafeCall(trace, receiverArgumentType);
        }
        context2.additionalTypeChecker.checkReceiver(receiverParameter, receiverArgument, safeAccess, context2);
        return ResolutionStatus.SUCCESS;
    }

    @NotNull
    public static JetType getEffectiveExpectedType(ValueParameterDescriptor parameterDescriptor, ValueArgument argument) {
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                JetType jetType = TypeUtils.DONT_CARE;
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
                }
                return jetType;
            }
            JetType jetType = parameterDescriptor.getType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
            }
            return jetType;
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            JetType jetType = varargElementType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
            }
            return jetType;
        }
        JetType jetType = parameterDescriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
        }
        return jetType;
    }

    private static void checkGenericBoundsInAFunctionCall(@NotNull List<JetTypeProjection> jetTypeArguments, @NotNull List<JetType> typeArguments, @NotNull CallableDescriptor functionDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull BindingTrace trace) {
        if (jetTypeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArguments", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        for (int i = 0; i < Math.min(typeParameters.size(), jetTypeArguments.size()); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            JetTypeReference typeReference = jetTypeArguments.get(i).getTypeReference();
            if (typeReference == null) continue;
            DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    public static class ValueArgumentsCheckingResult {
        @NotNull
        public final List<JetType> argumentTypes;
        @NotNull
        public final ResolutionStatus status;

        private ValueArgumentsCheckingResult(@NotNull ResolutionStatus status, @NotNull List<JetType> argumentTypes) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult", "<init>"));
            }
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult", "<init>"));
            }
            this.status = status;
            this.argumentTypes = argumentTypes;
        }
    }
}

