/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ScriptDescriptorImpl;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.data.DataPackage;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

public class ScriptBodyResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void resolveScriptBodies(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        for (Map.Entry<JetScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            if (c.getTopDownAnalysisParameters().isLazy()) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                continue;
            }
            ScriptDescriptorImpl descriptorImpl = (ScriptDescriptorImpl)descriptor;
            descriptorImpl.getScopeForBodyResolution().changeLockLevel(WritableScope.LockLevel.READING);
            JetType returnType = this.resolveScriptReturnType(declaration, descriptor, trace);
            ArrayList<PropertyDescriptorImpl> properties2 = new ArrayList<PropertyDescriptorImpl>();
            ArrayList<SimpleFunctionDescriptor> functions2 = new ArrayList<SimpleFunctionDescriptor>();
            BindingContext bindingContext = trace.getBindingContext();
            for (JetDeclaration jetDeclaration : declaration.getDeclarations()) {
                if (jetDeclaration instanceof JetProperty) {
                    if (!DataPackage.shouldBeScriptClassMember(jetDeclaration)) continue;
                    PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)bindingContext.get(BindingContext.VARIABLE, jetDeclaration);
                    properties2.add(propertyDescriptor);
                    continue;
                }
                if (!(jetDeclaration instanceof JetNamedFunction) || !DataPackage.shouldBeScriptClassMember(jetDeclaration)) continue;
                SimpleFunctionDescriptor function = bindingContext.get(BindingContext.FUNCTION, jetDeclaration);
                assert (function != null);
                functions2.add(function.copy(descriptor.getClassDescriptor(), function.getModality(), function.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false));
            }
            descriptorImpl.initialize(returnType, properties2, functions2);
        }
    }

    @NotNull
    public JetType resolveScriptReturnType(@NotNull JetScript script, @NotNull ScriptDescriptor scriptDescriptor, @NotNull BindingTrace trace) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.expressionTypingServices, trace, scriptDescriptor.getScopeForBodyResolution(), DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        JetType returnType = this.expressionTypingServices.getBlockReturnedType(script.getBlockExpression(), CoercionStrategy.NO_COERCION, context2).getType();
        if (returnType == null) {
            returnType = ErrorUtils.createErrorType("getBlockReturnedType returned null");
        }
        JetType jetType = returnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        return jetType;
    }
}

