/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.utils.UtilsPackage$collections$bb85935b;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"\u001d\u000e)\u0019B)Z2mCJ\fG/[8o%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\byM,G/L ?\u0015I\teN\\8uCRLwN\u001c*fg>dg/\u001a:\u000b'}\u000bgN\\8uCRLwN\u001c*fg>dg/\u001a:\u000b9}\u000bgN\\8uCRLwN\u001c*fg>dg/\u001a:%I\u0016dWmZ1uK*Q\u0001O]8qKJ$\u0018.Z:\u000b#I+\u0017\rZ,sSR,\u0007K]8qKJ$\u0018P\u0003\fhKR|\u0016M\u001c8pi\u0006$\u0018n\u001c8SKN|GN^3s\u0015Y\u0019X\r^0b]:|G/\u0019;j_:\u0014Vm]8mm\u0016\u0014(\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'BB0ue\u0006\u001cWMC\b`iJ\f7-\u001a\u0013eK2,w-\u0019;f\u0015%9W\r^0ue\u0006\u001cWMC\u0005tKR|FO]1dK*!3\r[3dWJ+G-Z2mCJ\fG/[8og&s\u0017J\u001c8fe\u000ec\u0017m]:OC6,7OC\u0001d\u0015Y!v\u000e\u001d#po:\fe.\u00197zg&\u001c8i\u001c8uKb$(\u0002B+oSRTQd\u00195fG.\u0014V\rZ3dY\u0006\u0014\u0018\r^5p]NLe\u000eU1dW\u0006<Wm\u001d\u0006\u001bi>\u0004H*\u001a<fY\u0012+7o\u0019:jaR|'\u000f\u0015:pm&$WM\u001d\u0006\u001b)>\u0004H*\u001a<fY\u0012+7o\u0019:jaR|'\u000f\u0015:pm&$WM\u001d\u0006\u0005Y\u0006T\u0018PC\bu_BdUM^3m\rFt\u0015-\\3t\u0015!iU\u000f\u001c;j[\u0006\u0004(bA2p[*1qm\\8hY\u0016TaaY8n[>t'bB2pY2,7\r\u001e\u0006\u0007\rFt\u0015-\\3\u000b\t9\fW.\u001a\u0006\u000b\u0015\u0016$X\t\\3nK:$(b\u00019tS*qr-\u001a;U_BdUM^3m\t\u0016\u001c8M]5qi>\u00148OQ=Gc:\u000bW.\u001a\u0006\u0007MFt\u0015-\\3\u000b\u0007M+GOC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\u0002\u0006:fa>\u0014HOU3eK\u000ed\u0017M]1uS>t7OC\u0007eKN\u001c'/\u001b9u_Jl\u0015\r\u001d\u0006\u0005\u001d\u0006lWMC\rsKN|GN^3B]:|G/\u0019;j_:\u001cxJ\u001c$jY\u0016\u001c(\"D:d_B,\u0007K]8wS\u0012,'OC\tGS2,7kY8qKB\u0013xN^5eKJTQc]3u\u0003:tw\u000e^1uS>t'+Z:pYZ,'O\u0003\nb]:|G/\u0019;j_:\u0014Vm]8mm\u0016\u0014(\u0002C:fiR\u0013\u0018mY3\u000b\u000bQ\u0014\u0018mY3\u007f\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019AQ\u0001E\u0003\u0019\u0001)1\u0001b\u0001\t\t1\u0001QA\u0001C\u0003\u0011\u0017)!\u0001\u0002\u0003\t\r\u0015\u0011A1\u0001\u0005\u0005\u000b\r!\u0019\u0001c\u0004\r\u0001\u0015\u0011A1\u0001E\b\u000b\r!\u0019\u0001C\u0006\r\u0001\u0015\u0019AQ\u0001E\f\u0019\u0001)!\u0001b\u0001\t\u0017\u0015\u0011A1\u0001E\u000e\u000b\r!\u0001\u0002C\u0007\r\u0001\u0015\t\u0001bD\u0003\u0003\t%Ay\"\u0002\u0002\u0005\u0014!\u0001RA\u0001\u0003\u000b\u0011C)1\u0001\"\u0006\t\u001e1\u0001QA\u0001\u0003\u0002\u0011G)1\u0001b\u0006\t#1\u0001QA\u0001\u0003\u0002\u0011K)1\u0001\"\u0007\t%1\u0001QA\u0001\u0003\t\u00115)!\u0001\"\u0006\t\u001e\u0015\u0019AQ\u0001\u0005\u0015\u0019\u0001)!\u0001B\u0001\t+\u0015\u0019Aa\u0004E\u0015\u0019\u0001)\u0011\u0001c\u000b\u0006\u0005\u0011\u0001\u0002BF\u0003\u0003\tCAA#\u0002\u0002\u0005\u0018!\tRa\u0001C\f\u0011_a\u0001!B\u0002\u0005\u0011!IB\u0002A\u0003\u0003\t!A\u0011\u0004B\u0002\r\u0005e\u0011Q!\u0001\u0005\u0004[{!\u0011\u0019\u0004M\u0005;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001r\u0001)\u0004\u0001\u0005\u0012Q!\u0001E\u0004I\u0005B\u0013%V\u0002\u000f\u000b\r!Q!C\u0001\t\n5\u0019AQB\u0005\u0002\u0011\u0015\tR\u0001B\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006[{!\u0011\u0019\u0004\r\t;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0006I\u0005B\u0013%V\u0002\u000f\u000b\r!\t\"C\u0001\t\n5\u0019A!C\u0005\u0002\u0011\u0019\tR\u0001b\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007[M!1\u0001\u0007\u0006\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001C\t)\u0011\u0001C\u0004R\u0007\u0015!!\"C\u0001\u0005\u00015\t\u0001rBW%\t\rAB\"(\u0004\u0005\u0001!eQBA\u0003\u0002\u0011#\u00016\u0001AO\u000f\t\u0001Aa\"\u0004\u0006\u0006\u0003!Y\u0011bA\u0005\u0003\u000b\u0005AA\"C\u0002\n\u0005\u0015\t\u0001\"\u0004)\u0004\u0002\u0005\u0012Q!\u0001\u0005\b#\u000e9A\u0001D\u0005\u0002\t\u0001i\u0011\u0001c\u0007\u000e\u0003!qQ\u0016\t\u0003\u00021Mij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001E\t!\u000e\u0001QT\u0002\u0003\u0001\u0011Oi!!B\u0001\t\u0019A\u001b\t!\t\u0004\u0006\u0003!u\u0011bA\u0005\u0003\u000b\u0005Ay\"U\u0002\b\tMI\u0011\u0001C\t\u000e\u0003!mQ\"\u0001E\u0012[m!\u0011\u0001'\f\u001e\u001e\u0011\u0001\u0001bF\u0007\u000b\u000b\u0005A1\"C\u0002\n\u0005\u0015\t\u0001BE\u0005\u0004\u0013\t)\u0011\u0001c\bQ\u0007\u0001\t#!B\u0001\t\u000fE\u001bQ\u0001\"\f\n\u0003\u0011\u0001Q\"\u0001\u0005\u000f[s!1\u0001\u0007\r\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0002\u0005\u0012Q!\u0001\u0005\b#\u000e9A\u0001G\u0005\u0002\t\u0001i\u0011\u0001c\u0004\u000e\u0003!\u0019Rf\u0005C\u00041gij\u0001\u0002\u0001\t55\u0011Q!\u0001E\u0004!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001d\t6!\u0002C\u001a\u0013\u0005!\u0001!D\u0001\t\u000b5\u001aBq\u0001M\u001b;\u001b!\u0001\u0001C\u000e\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\b#\u000e)AQG\u0005\u0002\t\u0001i\u0011\u0001\u0003\u00046\u0017\u0015QAa9\u0001\u0019\u0007\u0005\u0012Q!\u0001\u0005\u0003#\u000e\u0019AaA\u0005\u0002\t\u0001\u0001"})
public final class DeclarationResolver
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ReadWriteProperty<? super Object, AnnotationResolver> _annotationResolver$delegate = Delegates.INSTANCE$.notNull();
    private final ReadWriteProperty<? super Object, BindingTrace> _trace$delegate = Delegates.INSTANCE$.notNull();
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DeclarationResolver.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_annotationResolver"), new PropertyMetadataImpl("_trace")};
    }

    private final AnnotationResolver get_annotationResolver() {
        return this._annotationResolver$delegate.get(this, $propertyMetadata[0]);
    }

    private final void set_annotationResolver(@JetValueParameter(name="<set-?>") AnnotationResolver annotationResolver) {
        this._annotationResolver$delegate.set(this, $propertyMetadata[0], annotationResolver);
    }

    private final BindingTrace get_trace() {
        return this._trace$delegate.get(this, $propertyMetadata[1]);
    }

    private final void set_trace(@JetValueParameter(name="<set-?>") BindingTrace bindingTrace) {
        this._trace$delegate.set(this, $propertyMetadata[1], bindingTrace);
    }

    @Inject
    public final void setAnnotationResolver(@JetValueParameter(name="annotationResolver") @NotNull AnnotationResolver annotationResolver) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        this.set_annotationResolver(annotationResolver);
    }

    @Inject
    public final void setTrace(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.set_trace(trace);
    }

    public final void resolveAnnotationsOnFiles(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c, @JetValueParameter(name="scopeProvider") @NotNull FileScopeProvider scopeProvider) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Map filesToScope2 = UtilsPackage$collections$bb85935b.keysToMap((Iterable)c.getFiles(), (Function1)new Function1<JetFile, JetScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final JetScope invoke(@JetValueParameter(name="it") JetFile it) {
                JetFile jetFile = it;
                Intrinsics.checkExpressionValueIsNotNull(jetFile, "it");
                return this.$scopeProvider.getFileScope(jetFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
            }
        });
        Iterator iterator2 = KotlinPackage.iterator(filesToScope2);
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            JetFile file = (JetFile)KotlinPackage.component1(entry);
            JetScope fileScope = (JetScope)KotlinPackage.component2(entry);
            this.get_annotationResolver().resolveAnnotationsWithArguments(fileScope, file.getAnnotationEntries(), this.get_trace());
            this.get_annotationResolver().resolveAnnotationsWithArguments(fileScope, file.getDanglingAnnotations(), this.get_trace());
        }
    }

    public final void checkRedeclarationsInInnerClassNames(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            Collection<DeclarationDescriptor> descriptorsFromDefaultObject;
            if (DescriptorUtils.isDefaultObject(classDescriptor)) continue;
            Collection allDescriptors2 = classDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors();
            ClassDescriptorWithResolutionScopes defaultObject = classDescriptor.getDefaultObjectDescriptor();
            if (defaultObject != null && KotlinPackage.isNotEmpty(descriptorsFromDefaultObject = defaultObject.getScopeForMemberLookup().getOwnDeclaredDescriptors())) {
                allDescriptors2 = KotlinPackage.plus((Iterable)allDescriptors2, (Iterable)descriptorsFromDefaultObject);
            }
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : allDescriptors2) {
                if (!(!(desc instanceof ClassDescriptor) ? desc instanceof PropertyDescriptor : true)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            Multimap multimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(multimap, "descriptorMap");
            this.reportRedeclarations(multimap);
        }
    }

    private final void reportRedeclarations(@JetValueParameter(name="descriptorMap") Multimap<Name, DeclarationDescriptor> descriptorMap) {
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name pair : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(pair);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    if (descriptor == descriptor2) continue;
                    PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor);
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement, ((ClassDescriptor)descriptor).getName()));
                    if (!(descriptor2 instanceof PropertyDescriptor)) continue;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement2, ((PropertyDescriptor)descriptor2).getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            PsiElement first = (PsiElement)pair.component1();
            Name second = (Name)pair.component2();
            this.get_trace().report(Errors.REDECLARATION.on(first, second.asString()));
        }
    }

    public final void checkRedeclarationsInPackages(@JetValueParameter(name="topLevelDescriptorProvider") @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @JetValueParameter(name="topLevelFqNames") @NotNull Multimap<FqName, JetElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Iterator<Map.Entry<FqName, Collection<JetElement>>> iterator2 = KotlinPackage.iterator(topLevelFqNames.asMap());
        while (iterator2.hasNext()) {
            Map.Entry<FqName, Collection<JetElement>> entry = iterator2.next();
            FqName fqName2 = KotlinPackage.component1(entry);
            Collection<JetElement> declarationsOrPackageDirectives = KotlinPackage.component2(entry);
            if (fqName2.isRoot()) continue;
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            Set<DeclarationDescriptor> descriptors = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName3);
            if (descriptors.size() <= 1) continue;
            for (JetElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                PsiElement reportAt = declarationOrPackageDirective instanceof JetPackageDirective ? ((JetPackageDirective)declarationOrPackageDirective).getNameIdentifier() : (PsiElement)declarationOrPackageDirective;
                this.get_trace().report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(@JetValueParameter(name="topLevelDescriptorProvider") TopLevelDescriptorProvider topLevelDescriptorProvider, @JetValueParameter(name="fqName") FqName fqName2) {
        FqName parentFqName = fqName2.parent();
        HashSet<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        FqName fqName3 = parentFqName;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "parentFqName");
        LazyPackageDescriptor parentFragment = topLevelDescriptorProvider.getPackageFragment(fqName3);
        if (parentFragment != null) {
            JetScope jetScope = parentFragment.getMemberScope();
            Name name = fqName2.shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "fqName.shortName()");
            Iterable iterable = jetScope.getProperties(name);
            HashSet<ClassDescriptor> hashSet = descriptors;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            for (Object t : iterable2) {
                VariableDescriptor it = (VariableDescriptor)t;
                if (!(it.getExtensionReceiverParameter() == null)) continue;
                collection.add(t);
            }
            List list = (ArrayList)collection;
            hashSet.addAll(list);
        }
        UtilsPackage$collections$bb85935b.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2));
        return descriptors;
    }
}

