/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWhenEntry;

public class JetWhenExpression
extends JetExpressionImpl {
    public JetWhenExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetWhenExpression", "<init>"));
        }
        super(node);
    }

    @NotNull
    public List<JetWhenEntry> getEntries() {
        List<JetWhenEntry> list = this.findChildrenByType(JetNodeTypes.WHEN_ENTRY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetWhenExpression", "getEntries"));
        }
        return list;
    }

    @Nullable
    public JetExpression getSubjectExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetWhenExpression", "accept"));
        }
        return visitor.visitWhenExpression(this, data2);
    }

    @NotNull
    public PsiElement getWhenKeywordElement() {
        Object t = this.findChildByType(JetTokens.WHEN_KEYWORD);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetWhenExpression", "getWhenKeywordElement"));
        }
        return t;
    }

    @Nullable
    public PsiElement getCloseBrace() {
        return this.findChildByType(JetTokens.RBRACE);
    }

    @Nullable
    public PsiElement getOpenBrace() {
        return this.findChildByType(JetTokens.LBRACE);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(JetTokens.LPAR);
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(JetTokens.RPAR);
    }

    @Nullable
    public JetExpression getElseExpression() {
        for (JetWhenEntry entry : this.getEntries()) {
            if (!entry.isElse()) continue;
            return entry.getExpression();
        }
        return null;
    }
}

