/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetThisReferenceExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetDelegatorToThisCall
extends JetDelegationSpecifier
implements JetCallElement {
    public JetDelegatorToThisCall(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "<init>"));
        }
        super(node);
    }

    public JetDelegatorToThisCall(@NotNull KotlinPlaceHolderStub<? extends JetDelegationSpecifier> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "<init>"));
        }
        super(stub, (IStubElementType)JetStubElementTypes.THIS_CALL);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "accept"));
        }
        return visitor.visitDelegationToThisCall(this, data2);
    }

    @Override
    public JetExpression getCalleeExpression() {
        return this.getThisReference();
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
        List<JetFunctionLiteralArgument> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        List<JetTypeProjection> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDelegatorToThisCall", "getTypeArguments"));
        }
        return list;
    }

    @Override
    public JetTypeArgumentList getTypeArgumentList() {
        return null;
    }

    public JetReferenceExpression getThisReference() {
        return this.findChildByClass(JetThisReferenceExpression.class);
    }
}

