/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsTry;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.CatchTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetTryExpression;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"\u0007\u0006)iAK]=Ue\u0006t7\u000f\\1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0003UNT\u0011\u0002\u001e:b]Nd\u0017\r^3\u000b\u0015\u0015D\bO]3tg&|gN\u0003\nBEN$(/Y2u)J\fgn\u001d7bi>\u0014(bB4f]\u0016\u0014\u0018\r\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b!)+G\u000f\u0016:z\u000bb\u0004(/Z:tS>t'b\u00019tS*91m\u001c8uKb$(B\u0005+sC:\u001cH.\u0019;j_:\u001cuN\u001c;fqRTQbZ3u\u000bb\u0004(/Z:tS>t'\"\u0002&t)JL(bA2p[*1qm\\8hY\u0016TA\u0001Z1si*A1m\\7qS2,'OC\u0004cC\u000e\\WM\u001c3\u000b\u0007\u0005\u001cHO\u0003\tue\u0006t7\u000f\\1uK\u0006\u001b(\t\\8dW*i!*\u001a;FqB\u0014Xm]:j_:TqAS:CY>\u001c7Nm\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\t!!\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\t!\u0011\u0001c\u0003\u0006\u0007\u0011%\u0001\"\u0002\u0007\u0001\u000b\t!!\u0001\u0003\u0004\u0006\u0007\u0011-\u0001R\u0002\u0007\u0001\u000b\t!I\u0001C\u0003\u0006\u0005\u0011-\u0001RB\u0003\u0002\u0011!)!\u0001b\u0004\t\u0012\u0015\u0011A\u0001\u0003\u0005\n\u000b\t!\t\u0002c\u0005\u0006\u0005\u0011I\u0001BC\u0003\u0003\t'A!!\u0002\u0002\u0005\u0015!UQa\u0001C\u000b\u0011\u001fa\u0001!\u0002\u0002\u0005\u0016!=Qa\u0001C\u0005\u0011/a\u0001!B\u0002\u0005\u0016!aA\u0002A\u0003\u0003\t+AA\"\u0002\u0002\u0005\n!]Aa\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.\u001f\u0011\u0001G\u0001G\u0002\"\u0005\u0015\t\u0001\"B+\u0004\u0011\u0015\u0019AaA\u0005\u0002\u0011\u001bi1\u0001B\u0004\n\u0003!5Q6\u0003\u0003\u00041\u000b\t#!B\u0001\t\u0017E\u001b1\u0001\"\u0002\n\u0003!]Q&\u0006\u0003\u00021-iz\u0001\u0002\u0001\t\u00075\u0019Q!\u0001\u0005\r\u0019\u0003\u00016\u0001A\u0011\u0004\u000b\u0005AI\u0002$\u0001R\u0007\u0015!1\"C\u0001\t\u001b5\t\u00012D\u001b\u001f\u000bu!1\u001d\u0001M\u0005;\u001b!\u0001\u0001C\u0002\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u0007\u001b\t)\u0011\u0001\u0003\u0004Q\u0007\u0003\t#!B\u0001\t\u0007E\u001bq\u0001\"\u0003\n\u0003\u0011\u0001Q\"\u0001E\u0007\u001b\u0005Aq\u0001"})
public final class TryTranslator
extends AbstractTranslator
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetTryExpression expression;

    static {
        $kotlinClass = Reflection.createKotlinClass(TryTranslator.class);
    }

    @NotNull
    public final JsTry translate() {
        JsBlock tryBlock = this.translateAsBlock(this.expression.getTryBlock());
        List<JetCatchClause> list = this.expression.getCatchClauses();
        Intrinsics.checkExpressionValueIsNotNull(list, "expression.getCatchClauses()");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        CatchTranslator catchTranslator = new CatchTranslator(list, translationContext);
        JsCatch catchBlock = catchTranslator.translate();
        JetFinallySection jetFinallySection = this.expression.getFinallyBlock();
        JetBlockExpression finallyExpression = jetFinallySection != null ? jetFinallySection.getFinalExpression() : null;
        JsBlock finallyBlock = this.translateAsBlock(finallyExpression);
        return new JsTry(tryBlock, catchBlock, finallyBlock);
    }

    private final JsBlock translateAsBlock(@JetValueParameter(name="expression", type="?") JetExpression expression) {
        if (expression == null) {
            return null;
        }
        JsStatement statement = Translation.translateAsStatementAndMergeInBlockIfNeeded(expression, this.context());
        return JsAstUtils.convertToBlock(statement);
    }

    @NotNull
    public final JetTryExpression getExpression() {
        return this.expression;
    }

    public TryTranslator(@JetValueParameter(name="expression") @NotNull JetTryExpression expression, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        super(context2);
        this.expression = expression;
    }
}

