/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesPackage;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.DefinitionPlace;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.declaration.JsDataClassGenerator;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorPackage;
import org.jetbrains.kotlin.js.translate.expression.ExpressionPackage;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsPackage;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public final class ClassTranslator
extends AbstractTranslator {
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final ClassDescriptor descriptor;

    @NotNull
    public static JsInvocation generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context2) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        JsInvocation jsInvocation = new ClassTranslator(classDeclaration, context2).translate();
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateClassCreation"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectDeclaration objectDeclaration, @NotNull TranslationContext context2) {
        if (objectDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        JsExpression jsExpression = new ClassTranslator(objectDeclaration, context2).translateObjectLiteralExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateObjectLiteral"));
        }
        return jsExpression;
    }

    private ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context2) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "<init>"));
        }
        super(context2);
        this.classDeclaration = classDeclaration;
        this.descriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), classDeclaration);
    }

    @NotNull
    private JsExpression translateObjectLiteralExpression() {
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            JsInvocation jsInvocation = this.translate(this.context());
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translateObjectLiteralExpression"));
            }
            return jsInvocation;
        }
        JsExpression jsExpression = this.translateObjectInsideClass(this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translateObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsInvocation translate() {
        JsInvocation jsInvocation = this.translate(this.context());
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translate"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsInvocation translate(@NotNull TranslationContext declarationContext) {
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translate"));
        }
        JsInvocation jsInvocation = new JsInvocation(this.context().namer().classCreateInvocation(this.descriptor), this.getClassCreateInvocationArguments(declarationContext));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translate"));
        }
        return jsInvocation;
    }

    private boolean isTrait() {
        return this.descriptor.getKind().equals((Object)ClassKind.TRAIT);
    }

    @NotNull
    private List<JsExpression> getClassCreateInvocationArguments(@NotNull TranslationContext declarationContext) {
        boolean hasStaticProperties;
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getClassCreateInvocationArguments"));
        }
        ArrayList<JsExpression> invocationArguments = new ArrayList<JsExpression>();
        SmartList<JsPropertyInitializer> properties2 = new SmartList<JsPropertyInitializer>();
        SmartList<JsPropertyInitializer> staticProperties = new SmartList<JsPropertyInitializer>();
        boolean isTopLevelDeclaration = this.context() == declarationContext;
        JsNameRef qualifiedReference = null;
        if (isTopLevelDeclaration) {
            DefinitionPlace definitionPlace = null;
            if (!this.descriptor.getKind().isSingleton() && !DescriptorUtils.isAnonymousObject(this.descriptor)) {
                qualifiedReference = declarationContext.getQualifiedReference(this.descriptor);
                JsScope scope2 = this.context().getScopeForDescriptor(this.descriptor);
                definitionPlace = new DefinitionPlace((JsObjectScope)scope2, qualifiedReference, staticProperties);
            }
            declarationContext = declarationContext.newDeclaration(this.descriptor, definitionPlace);
        }
        declarationContext = this.fixContextForDefaultObjectAccessing(declarationContext);
        invocationArguments.add(this.getSuperclassReferences(declarationContext));
        DelegationTranslator delegationTranslator = new DelegationTranslator(this.classDeclaration, this.context());
        if (!this.isTrait()) {
            JsFunction initializer = new ClassInitializerTranslator(this.classDeclaration, declarationContext).generateInitializeMethod(delegationTranslator);
            invocationArguments.add(initializer.getBody().getStatements().isEmpty() ? JsLiteral.NULL : initializer);
        }
        this.translatePropertiesAsConstructorParameters(declarationContext, properties2);
        DeclarationBodyVisitor bodyVisitor = new DeclarationBodyVisitor(properties2, staticProperties);
        bodyVisitor.traverseContainer(this.classDeclaration, declarationContext);
        delegationTranslator.generateDelegated(properties2);
        if (KotlinBuiltIns.isData(this.descriptor)) {
            new JsDataClassGenerator(this.classDeclaration, declarationContext, properties2).generate();
        }
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            JsObjectLiteral enumEntries = new JsObjectLiteral(bodyVisitor.getEnumEntryList(), true);
            JsFunction function = TranslationUtils.simpleReturnFunction(declarationContext.getScopeForDescriptor(this.descriptor), enumEntries);
            invocationArguments.add(function);
        }
        this.generatedBridgeMethods(properties2);
        boolean bl = hasStaticProperties = !staticProperties.isEmpty();
        if (!properties2.isEmpty() || hasStaticProperties) {
            if (properties2.isEmpty()) {
                invocationArguments.add(JsLiteral.NULL);
            } else {
                if (qualifiedReference != null) {
                    invocationArguments.add(new JsDocComment("lends", new JsNameRef("prototype", (JsExpression)qualifiedReference)));
                }
                invocationArguments.add(new JsObjectLiteral(properties2, true));
            }
        }
        if (hasStaticProperties) {
            invocationArguments.add(new JsDocComment("lends", qualifiedReference));
            invocationArguments.add(new JsObjectLiteral(staticProperties, true));
        }
        ArrayList<JsExpression> arrayList = invocationArguments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getClassCreateInvocationArguments"));
        }
        return arrayList;
    }

    private TranslationContext fixContextForDefaultObjectAccessing(TranslationContext declarationContext) {
        ClassDescriptor defaultObjectDescriptor2 = this.descriptor.getDefaultObjectDescriptor();
        if (defaultObjectDescriptor2 != null) {
            JsExpression referenceToClass = ReferenceTranslator.translateAsFQReference(defaultObjectDescriptor2.getContainingDeclaration(), declarationContext);
            JsExpression defaultObjectAccessor = Namer.getDefaultObjectAccessor(referenceToClass);
            ReceiverParameterDescriptor defaultObjectReceiver = JsDescriptorUtils.getReceiverParameterForDeclaration(defaultObjectDescriptor2);
            declarationContext.aliasingContext().registerAlias(defaultObjectReceiver, defaultObjectAccessor);
        }
        if (DescriptorUtils.isDefaultObject(this.descriptor)) {
            declarationContext = declarationContext.innerContextWithAliased(this.descriptor.getThisAsReceiverParameter(), JsLiteral.THIS);
        }
        return declarationContext;
    }

    private JsExpression getSuperclassReferences(@NotNull TranslationContext declarationContext) {
        if (declarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationContext", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getSuperclassReferences"));
        }
        List<JsExpression> superClassReferences = this.getSupertypesNameReferences();
        if (superClassReferences.isEmpty()) {
            return JsLiteral.NULL;
        }
        return TranslationUtils.simpleReturnFunction(declarationContext.scope(), new JsArrayLiteral(superClassReferences));
    }

    @NotNull
    private List<JsExpression> getSupertypesNameReferences() {
        List<JetType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(this.descriptor);
        if (supertypes2.isEmpty()) {
            List<JsExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
            }
            return list;
        }
        if (supertypes2.size() == 1) {
            JetType type2 = supertypes2.get(0);
            ClassDescriptor supertypeDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
            List<JsExpression> list = Collections.singletonList(this.getClassReference(supertypeDescriptor));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
            }
            return list;
        }
        HashSet<TypeConstructor> supertypeConstructors = new HashSet<TypeConstructor>();
        for (JetType type3 : supertypes2) {
            supertypeConstructors.add(type3.getConstructor());
        }
        List<TypeConstructor> sortedAllSuperTypes = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(this.descriptor.getDefaultType(), new HashMap<TypeConstructor, Set<JetType>>(), new HashSet<TypeConstructor>());
        ArrayList<JsExpression> supertypesRefs = new ArrayList<JsExpression>();
        for (TypeConstructor typeConstructor2 : sortedAllSuperTypes) {
            if (!supertypeConstructors.contains(typeConstructor2)) continue;
            ClassDescriptor supertypeDescriptor = DescriptorUtils.getClassDescriptorForTypeConstructor(typeConstructor2);
            supertypesRefs.add(this.getClassReference(supertypeDescriptor));
        }
        ArrayList<JsExpression> arrayList = supertypesRefs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getSupertypesNameReferences"));
        }
        return arrayList;
    }

    @NotNull
    private JsNameRef getClassReference(@NotNull ClassDescriptor superClassDescriptor) {
        if (superClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassDescriptor", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getClassReference"));
        }
        JsNameRef jsNameRef = this.context().getQualifiedReference(superClassDescriptor);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "getClassReference"));
        }
        return jsNameRef;
    }

    private void translatePropertiesAsConstructorParameters(@NotNull TranslationContext classDeclarationContext, @NotNull List<JsPropertyInitializer> result2) {
        if (classDeclarationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclarationContext", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translatePropertiesAsConstructorParameters"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translatePropertiesAsConstructorParameters"));
        }
        for (JetParameter parameter : PsiUtils.getPrimaryConstructorParameters(this.classDeclaration)) {
            PropertyDescriptor descriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor == null) continue;
            PropertyTranslatorPackage.translateAccessors(descriptor, result2, classDeclarationContext);
        }
    }

    @NotNull
    private JsExpression translateObjectInsideClass(@NotNull TranslationContext outerClassContext) {
        if (outerClassContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerClassContext", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translateObjectInsideClass"));
        }
        JsFunction fun = new JsFunction(outerClassContext.scope(), new JsBlock(), "initializer for " + this.descriptor.getName().asString());
        TranslationContext funContext = outerClassContext.newFunctionBodyWithUsageTracker(fun, this.descriptor);
        fun.getBody().getStatements().add(new JsReturn(this.translate(funContext)));
        JsExpression jsExpression = ExpressionPackage.withCapturedParameters(fun, funContext, outerClassContext, this.descriptor);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "translateObjectInsideClass"));
        }
        return jsExpression;
    }

    private void generatedBridgeMethods(@NotNull List<JsPropertyInitializer> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generatedBridgeMethods"));
        }
        if (this.isTrait()) {
            return;
        }
        this.generateBridgesToTraitImpl(properties2);
        this.generateOtherBridges(properties2);
    }

    private void generateBridgesToTraitImpl(List<JsPropertyInitializer> properties2) {
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getTraitMethods(this.descriptor).entrySet()) {
            if (this.areNamesEqual(entry.getKey(), entry.getValue())) continue;
            properties2.add(UtilsPackage.generateDelegateCall(entry.getValue(), entry.getKey(), JsLiteral.THIS, this.context()));
        }
    }

    private void generateOtherBridges(List<JsPropertyInitializer> properties2) {
        for (DeclarationDescriptor memberDescriptor : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            if (!(memberDescriptor instanceof FunctionDescriptor)) continue;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)memberDescriptor;
            Set bridgesToGenerate = BridgesPackage.generateBridgesForFunctionDescriptor(functionDescriptor, UtilsPackage.getID());
            for (Bridge<FunctionDescriptor> bridge : bridgesToGenerate) {
                this.generateBridge(bridge, properties2);
            }
        }
    }

    private void generateBridge(@NotNull Bridge<FunctionDescriptor> bridge, @NotNull List<JsPropertyInitializer> properties2) {
        FunctionDescriptor toDescriptor;
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateBridge"));
        }
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "generateBridge"));
        }
        FunctionDescriptor fromDescriptor = bridge.getFrom();
        if (this.areNamesEqual(fromDescriptor, toDescriptor = bridge.getTo())) {
            return;
        }
        if (fromDescriptor.getKind().isReal() && fromDescriptor.getModality() != Modality.ABSTRACT && !toDescriptor.getKind().isReal()) {
            return;
        }
        properties2.add(UtilsPackage.generateDelegateCall(fromDescriptor, toDescriptor, JsLiteral.THIS, this.context()));
    }

    private boolean areNamesEqual(@NotNull FunctionDescriptor first, @NotNull FunctionDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "areNamesEqual"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/kotlin/js/translate/declaration/ClassTranslator", "areNamesEqual"));
        }
        JsName firstName = this.context().getNameForDescriptor(first);
        JsName secondName = this.context().getNameForDescriptor(second);
        return firstName.getIdent().equals(secondName.getIdent());
    }
}

