/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.google.common.base.Predicates;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public final class K2JSTranslator {
    public static final String FLUSH_SYSTEM_OUT = "Kotlin.out.flush();\n";
    public static final String GET_SYSTEM_OUT = "Kotlin.out.buffer;\n";
    @NotNull
    private final Config config;

    public K2JSTranslator(@NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        JsAnalysisResult analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), this.config);
        BindingTrace bindingTrace = analysisResult.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(Config.withJsLibAdded(files, this.config), bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        JsProgram program = Translation.generateAst(bindingTrace, files, mainCallParameters, moduleDescriptor, this.config);
        Diagnostics diagnostics = bindingTrace.getBindingContext().getDiagnostics();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        program = JsInliner.process(program);
        TranslationResult.Success success = new TranslationResult.Success(this.config, files, program, diagnostics);
        if (success == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        return success;
    }
}

