/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.GlobalContextImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisParameters;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public final class TopDownAnalyzerFacadeForJS {
    public static final List<ImportPath> DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.js.*"));

    private TopDownAnalyzerFacadeForJS() {
    }

    @NotNull
    public static BindingContext analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext bindingContext = TopDownAnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return bindingContext;
    }

    @NotNull
    public static JsAnalysisResult analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext libraryContext = config.getLibraryContext();
        BindingTrace trace = libraryContext == null ? new BindingTraceContext() : new DelegatingBindingTrace(libraryContext, "trace with preanalyzed library");
        ModuleDescriptorImpl module = TopDownAnalyzerFacadeForJS.createJsModule("<module>");
        module.addDependencyOnModule(module);
        module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        ModuleDescriptor libraryModule = config.getLibraryModule();
        if (libraryModule != null) {
            module.addDependencyOnModule((ModuleDescriptorImpl)libraryModule);
        }
        module.seal();
        JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files, trace, module, filesToAnalyzeCompletely, config);
        if (jsAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return jsAnalysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull ModuleDescriptorImpl module, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        Project project = config.getProject();
        Predicate<PsiFile> completely = Predicates.and(TopDownAnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), completely, false, false);
        Collection<JetFile> allFiles = config.getLibraryModule() != null ? files : Config.withJsLibAdded(files, config);
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, trace, module, new FileBasedDeclarationProviderFactory(topDownAnalysisParameters.getStorageManager(), allFiles));
        injector.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(topDownAnalysisParameters, allFiles, Collections.emptyList());
        JsAnalysisResult jsAnalysisResult = JsAnalysisResult.success(trace, (ModuleDescriptor)module);
        JsAnalysisResult jsAnalysisResult2 = jsAnalysisResult;
        if (jsAnalysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        return jsAnalysisResult2;
        finally {
            injector.destroy();
        }
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    private static Predicate<PsiFile> notLibFiles(final @NotNull List<JetFile> jsLibFiles) {
        if (jsLibFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLibFiles", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "notLibFiles"));
        }
        Predicate<PsiFile> predicate = new Predicate<PsiFile>(){

            @Override
            public boolean apply(@Nullable PsiFile file) {
                assert (file instanceof JetFile);
                boolean notLibFile = !jsLibFiles.contains(file);
                return notLibFile;
            }
        };
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "notLibFiles"));
        }
        return predicate;
    }

    @NotNull
    public static ModuleDescriptorImpl createJsModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        return moduleDescriptorImpl;
    }
}

