/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.optimization.OptimizationClassBuilder;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;

public class OptimizationClassBuilderFactory
implements ClassBuilderFactory {
    private final ClassBuilderFactory delegate;

    public OptimizationClassBuilderFactory(ClassBuilderFactory delegate2) {
        this.delegate = delegate2;
    }

    @Override
    @NotNull
    public ClassBuilderMode getClassBuilderMode() {
        ClassBuilderMode classBuilderMode = this.delegate.getClassBuilderMode();
        if (classBuilderMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilderFactory", "getClassBuilderMode"));
        }
        return classBuilderMode;
    }

    @Override
    @NotNull
    public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilderFactory", "newClassBuilder"));
        }
        OptimizationClassBuilder optimizationClassBuilder = new OptimizationClassBuilder(this.delegate.newClassBuilder(origin));
        if (optimizationClassBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilderFactory", "newClassBuilder"));
        }
        return optimizationClassBuilder;
    }

    @Override
    public String asText(ClassBuilder builder) {
        return this.delegate.asText(((OptimizationClassBuilder)builder).getDelegate());
    }

    @Override
    public byte[] asBytes(ClassBuilder builder) {
        return this.delegate.asBytes(((OptimizationClassBuilder)builder).getDelegate());
    }
}

