/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.inline.MaxStackFrameSizeAndLocalsCalculator;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InlineCodegenUtil {
    public static final int API = 327680;
    public static final String INVOKE = "invoke";
    public static final String CAPTURED_FIELD_PREFIX = "$";
    public static final String THIS$0 = "this$0";
    public static final String RECEIVER$0 = "receiver$0";
    public static final String NON_LOCAL_RETURN = "$$$$$NON_LOCAL_RETURN$$$$$";
    public static final String ROOT_LABEL = "$$$$$ROOT$$$$$";
    public static final String INLINE_MARKER_CLASS_NAME = "kotlin/jvm/internal/InlineMarker";
    public static final String INLINE_MARKER_BEFORE_METHOD_NAME = "beforeInlineCall";
    public static final String INLINE_MARKER_AFTER_METHOD_NAME = "afterInlineCall";
    public static final String INLINE_MARKER_GOTO_TRY_CATCH_BLOCK_END = "goToTryCatchBlockEnd";

    @Nullable
    public static MethodNode getMethodNode(byte[] classData, final String methodName, final String methodDescriptor) throws ClassNotFoundException, IOException {
        ClassReader cr = new ClassReader(classData);
        final MethodNode[] methodNode = new MethodNode[1];
        cr.accept(new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, String signature, String[] exceptions) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1", "visitMethod"));
                }
                if (methodName.equals(name) && methodDescriptor.equals(desc)) {
                    methodNode[0] = new MethodNode(access, name, desc, signature, exceptions);
                    return methodNode[0];
                }
                return null;
            }
        }, 6);
        return methodNode[0];
    }

    @NotNull
    public static VirtualFile getVirtualFileForCallable(@NotNull DeserializedSimpleFunctionDescriptor deserializedDescriptor, @NotNull GenerationState state) {
        VirtualFile file;
        if (deserializedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            ProtoBuf.Callable proto = deserializedDescriptor.getProto();
            if (!proto.hasExtension(JvmProtoBuf.implClassName)) {
                throw new IllegalStateException("Function in namespace should have implClassName property in proto: " + deserializedDescriptor);
            }
            Name name = deserializedDescriptor.getNameResolver().getName(proto.getExtension(JvmProtoBuf.implClassName));
            FqName packagePartFqName = PackageClassUtils.getPackageClassFqName(((PackageFragmentDescriptor)parentDeclaration).getFqName()).parent().child(name);
            file = InlineCodegenUtil.findVirtualFileWithHeader(state.getProject(), packagePartFqName);
        } else {
            file = InlineCodegenUtil.findVirtualFileContainingDescriptor(state.getProject(), deserializedDescriptor);
        }
        if (file == null) {
            throw new IllegalStateException("Couldn't find declaration file for " + deserializedDescriptor.getName());
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile findVirtualFileWithHeader(@NotNull Project project, @NotNull FqName containerFqName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileWithHeader"));
        }
        if (containerFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerFqName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileWithHeader"));
        }
        VirtualFileFinder fileFinder = VirtualFileFinder.SERVICE.getInstance(project);
        return fileFinder.findVirtualFileWithHeader(containerFqName);
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull Project project, @NotNull String internalName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        VirtualFileFinder fileFinder = VirtualFileFinder.SERVICE.getInstance(project);
        return fileFinder.findVirtualFile(internalName);
    }

    @Nullable
    public static FqName getContainerFqName(@NotNull DeclarationDescriptor referencedDescriptor) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getContainerFqName"));
        }
        ClassOrPackageFragmentDescriptor containerDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, ClassOrPackageFragmentDescriptor.class, false);
        if (containerDescriptor instanceof PackageFragmentDescriptor) {
            return PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFqName(containerDescriptor).toSafe());
        }
        if (containerDescriptor instanceof ClassDescriptor) {
            FqName fqName2 = DescriptorUtils.getFqNameSafe(containerDescriptor);
            if (DescriptorUtils.isTrait(containerDescriptor)) {
                return fqName2.parent().child(Name.identifier(fqName2.shortName() + "$$TImpl"));
            }
            return fqName2;
        }
        return null;
    }

    public static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull JetTypeMapper typeMapper) {
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        return InlineCodegenUtil.getInlineName(codegenContext, codegenContext.getContextDescriptor(), typeMapper);
    }

    private static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull DeclarationDescriptor currentDescriptor, @NotNull JetTypeMapper typeMapper) {
        ClassDescriptor descriptor;
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor instanceof PackageFragmentDescriptor) {
            Type packagePartType;
            PsiFile file = InlineCodegenUtil.getContainingFile(codegenContext);
            if (file == null) {
                assert (codegenContext instanceof PackageContext) : "Expected package context but " + codegenContext;
                packagePartType = ((PackageContext)codegenContext).getPackagePartType();
            } else {
                packagePartType = PackagePartClassUtils.getPackagePartType((JetFile)file);
            }
            if (packagePartType == null) {
                Object contextDescriptor = codegenContext.getContextDescriptor();
                throw new RuntimeException("Couldn't find declaration for " + contextDescriptor.getContainingDeclaration().getName() + "." + contextDescriptor.getName());
            }
            return packagePartType.getInternalName();
        }
        if (currentDescriptor instanceof ClassifierDescriptor) {
            Type type2 = typeMapper.mapType((ClassifierDescriptor)currentDescriptor);
            return type2.getInternalName();
        }
        if (currentDescriptor instanceof FunctionDescriptor && (descriptor = typeMapper.getBindingContext().get(CodegenBinding.CLASS_FOR_FUNCTION, (FunctionDescriptor)currentDescriptor)) != null) {
            Type type3 = typeMapper.mapType(descriptor);
            return type3.getInternalName();
        }
        String suffix = currentDescriptor.getName().isSpecial() ? "" : currentDescriptor.getName().asString();
        return InlineCodegenUtil.getInlineName(codegenContext, currentDescriptor.getContainingDeclaration(), typeMapper) + CAPTURED_FIELD_PREFIX + suffix;
    }

    @Nullable
    private static VirtualFile findVirtualFileContainingDescriptor(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileContainingDescriptor"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileContainingDescriptor"));
        }
        FqName containerFqName = InlineCodegenUtil.getContainerFqName(referencedDescriptor);
        if (containerFqName == null) {
            return null;
        }
        return InlineCodegenUtil.findVirtualFileWithHeader(project, containerFqName);
    }

    public static boolean isInvokeOnLambda(String owner, String name) {
        if (!INVOKE.equals(name)) {
            return false;
        }
        for (String prefix : Arrays.asList("kotlin/Function", "kotlin/ExtensionFunction")) {
            String suffix;
            if (!owner.startsWith(prefix) || !InlineCodegenUtil.isInteger(suffix = owner.substring(prefix.length()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnonymousConstructorCall(@NotNull String internalName, @NotNull String methodName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousConstructorCall"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousConstructorCall"));
        }
        return "<init>".equals(methodName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isAnonymousSingletonLoad(@NotNull String internalName, @NotNull String fieldName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousSingletonLoad"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousSingletonLoad"));
        }
        return "INSTANCE$".equals(fieldName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isAnonymousClass(String internalName) {
        String shortName = InlineCodegenUtil.getLastNamePart(internalName);
        int index2 = shortName.lastIndexOf(CAPTURED_FIELD_PREFIX);
        if (index2 < 0) {
            return false;
        }
        String suffix = shortName.substring(index2 + 1);
        return InlineCodegenUtil.isInteger(suffix);
    }

    @NotNull
    private static String getLastNamePart(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        int index2 = internalName.lastIndexOf("/");
        String string = index2 < 0 ? internalName : internalName.substring(index2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        return string;
    }

    @Nullable
    public static PsiFile getContainingFile(CodegenContext codegenContext) {
        Object contextDescriptor = codegenContext.getContextDescriptor();
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(contextDescriptor);
        if (psiElement != null) {
            return psiElement.getContainingFile();
        }
        return null;
    }

    @NotNull
    public static MethodVisitor wrapWithMaxLocalCalc(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        MaxStackFrameSizeAndLocalsCalculator maxStackFrameSizeAndLocalsCalculator = new MaxStackFrameSizeAndLocalsCalculator(327680, methodNode.access, methodNode.desc, methodNode);
        if (maxStackFrameSizeAndLocalsCalculator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        return maxStackFrameSizeAndLocalsCalculator;
    }

    private static boolean isInteger(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isInteger"));
        }
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCapturedFieldName(@NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isCapturedFieldName"));
        }
        return fieldName.startsWith(CAPTURED_FIELD_PREFIX) && !fieldName.equals("$kotlinClass") || THIS$0.equals(fieldName) || RECEIVER$0.equals(fieldName);
    }

    public static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static boolean isMarkedReturn(@NotNull AbstractInsnNode returnIns) {
        if (returnIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnIns", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isMarkedReturn"));
        }
        assert (InlineCodegenUtil.isReturnOpcode(returnIns.getOpcode())) : "Should be called on return instruction, but " + returnIns;
        AbstractInsnNode globalFlag = returnIns.getPrevious();
        return globalFlag instanceof MethodInsnNode && NON_LOCAL_RETURN.equals(((MethodInsnNode)globalFlag).owner);
    }

    public static void generateGlobalReturnFlag(@NotNull InstructionAdapter iv, @NotNull String labelName) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateGlobalReturnFlag"));
        }
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateGlobalReturnFlag"));
        }
        iv.invokestatic(NON_LOCAL_RETURN, labelName, "()V", false);
    }

    public static Type getReturnType(int opcode) {
        switch (opcode) {
            case 177: {
                return Type.VOID_TYPE;
            }
            case 172: {
                return Type.INT_TYPE;
            }
            case 175: {
                return Type.DOUBLE_TYPE;
            }
            case 174: {
                return Type.FLOAT_TYPE;
            }
            case 173: {
                return Type.LONG_TYPE;
            }
        }
        return AsmTypes.OBJECT_TYPE;
    }

    public static void insertNodeBefore(@NotNull MethodNode from, @NotNull MethodNode to, @NotNull AbstractInsnNode beforeNode) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (beforeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        InsnList instructions = to.instructions;
        ListIterator<AbstractInsnNode> iterator2 = from.instructions.iterator();
        while (iterator2.hasNext()) {
            AbstractInsnNode next = iterator2.next();
            instructions.insertBefore(beforeNode, next);
        }
    }

    public static MethodNode createEmptyMethodNode() {
        return new MethodNode(327680, 0, "fake", "()V", null, null);
    }

    static boolean isLineNumberOrLabel(@Nullable AbstractInsnNode node) {
        return node instanceof LineNumberNode || node instanceof LabelNode;
    }

    @NotNull
    public static LabelNode firstLabelInChain(@NotNull LabelNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "firstLabelInChain"));
        }
        LabelNode curNode = node;
        while (curNode.getPrevious() instanceof LabelNode) {
            curNode = (LabelNode)curNode.getPrevious();
        }
        LabelNode labelNode = curNode;
        if (labelNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "firstLabelInChain"));
        }
        return labelNode;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node) {
        String string = InlineCodegenUtil.getNodeText(node, new Textifier());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        return string;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node, @NotNull Textifier textifier) {
        if (textifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textifier", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        if (node == null) {
            if ("Not generated" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
            }
            return "Not generated";
        }
        node.accept(new TraceMethodVisitor(textifier));
        StringWriter sw = new StringWriter();
        textifier.print(new PrintWriter(sw));
        sw.flush();
        String string = node.name + " " + node.desc + ": \n " + sw.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        return string;
    }

    @NotNull
    static ClassReader buildClassReaderByInternalName(@NotNull GenerationState state, @NotNull String internalName) {
        ClassReader classReader;
        block8: {
            block6: {
                ClassReader classReader2;
                block7: {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                    }
                    if (internalName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                    }
                    try {
                        OutputFile outputFile = state.getFactory().get(internalName + ".class");
                        if (outputFile == null) break block6;
                        classReader2 = new ClassReader(outputFile.asByteArray());
                        if (classReader2 != null) break block7;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                }
                return classReader2;
            }
            VirtualFile file = InlineCodegenUtil.findVirtualFile(state.getProject(), internalName);
            if (file == null) {
                throw new RuntimeException("Couldn't find virtual file for " + internalName);
            }
            classReader = new ClassReader(file.contentsToByteArray());
            if (classReader != null) break block8;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
        }
        return classReader;
    }

    public static void generateGoToTryCatchBlockEndMarker(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateGoToTryCatchBlockEndMarker"));
        }
        v.invokestatic(INLINE_MARKER_CLASS_NAME, INLINE_MARKER_GOTO_TRY_CATCH_BLOCK_END, "()V", false);
    }

    public static boolean isGoToTryCatchBlockEnd(@NotNull AbstractInsnNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isGoToTryCatchBlockEnd"));
        }
        if (!(node.getPrevious() instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode previous = (MethodInsnNode)node.getPrevious();
        return node.getOpcode() == 167 && INLINE_MARKER_CLASS_NAME.equals(previous.owner) && INLINE_MARKER_GOTO_TRY_CATCH_BLOCK_END.equals(previous.name);
    }

    public static void addInlineMarker(@NotNull InstructionAdapter v, boolean isStartNotEnd) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "addInlineMarker"));
        }
        v.visitMethodInsn(184, INLINE_MARKER_CLASS_NAME, isStartNotEnd ? INLINE_MARKER_BEFORE_METHOD_NAME : INLINE_MARKER_AFTER_METHOD_NAME, "()V", false);
    }

    public static class LabelTextifier
    extends Textifier {
        public LabelTextifier() {
            super(327680);
        }

        @Nullable
        public String getLabelNameIfExists(@NotNull Label l) {
            if (l == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$LabelTextifier", "getLabelNameIfExists"));
            }
            return this.labelNames == null ? null : (String)this.labelNames.get(l);
        }
    }
}

