/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ClassBuilderFactories {
    @NotNull
    public static ClassBuilderFactory THROW_EXCEPTION = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.FULL;
            if (classBuilderMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$1", "getClassBuilderMode"));
            }
            return classBuilderMode;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$1", "newClassBuilder"));
            }
            throw new IllegalStateException();
        }

        @Override
        public String asText(ClassBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new IllegalStateException();
        }
    };
    @NotNull
    public static ClassBuilderFactory TEST = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.FULL;
            if (classBuilderMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "getClassBuilderMode"));
            }
            return classBuilderMode;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "newClassBuilder"));
            }
            TraceBuilder traceBuilder = new TraceBuilder(new BinaryClassWriter());
            if (traceBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$2", "newClassBuilder"));
            }
            return traceBuilder;
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor.p.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            return ((TraceBuilder)builder).binary.toByteArray();
        }
    };
    @NotNull
    public static ClassBuilderFactory BINARIES = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.FULL;
            if (classBuilderMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$3", "getClassBuilderMode"));
            }
            return classBuilderMode;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$3", "newClassBuilder"));
            }
            AbstractClassBuilder.Concrete concrete = new AbstractClassBuilder.Concrete(new BinaryClassWriter());
            if (concrete == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$3", "newClassBuilder"));
            }
            return concrete;
        }

        @Override
        public String asText(ClassBuilder builder) {
            throw new UnsupportedOperationException("BINARIES generator asked for text");
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            ClassWriter visitor = (ClassWriter)builder.getVisitor();
            return visitor.toByteArray();
        }
    };

    private ClassBuilderFactories() {
    }

    private static class TraceBuilder
    extends AbstractClassBuilder.Concrete {
        public final BinaryClassWriter binary;

        public TraceBuilder(BinaryClassWriter binary) {
            super(new TraceClassVisitor(binary, new PrintWriter(new StringWriter())));
            this.binary = binary;
        }
    }

    private static class BinaryClassWriter
    extends ClassWriter {
        public BinaryClassWriter() {
            super(3);
        }

        @Override
        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            if (type1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$BinaryClassWriter", "getCommonSuperClass"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/kotlin/codegen/ClassBuilderFactories$BinaryClassWriter", "getCommonSuperClass"));
            }
            try {
                return super.getCommonSuperClass(type1, type2);
            }
            catch (Throwable t) {
                return "java/lang/Object";
            }
        }
    }
}

