/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsPackage;
import org.jetbrains.kotlin.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.LibrarySourcesConfig;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.utils.PathUtil;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createArguments() {
        K2JSCompilerArguments k2JSCompilerArguments = new K2JSCompilerArguments();
        if (k2JSCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "createArguments"));
        }
        return k2JSCompilerArguments;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull Services services, final @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        TranslationResult translationResult;
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (arguments2.freeArgs.isEmpty()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        CompilerJarLocator locator = services.get(CompilerJarLocator.class);
        if (locator != null) {
            configuration.put(JVMConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, arguments2.freeArgs);
        JetCoreEnvironment environmentForJS = JetCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<JetFile> sourcesFiles = environmentForJS.getSourceFiles();
        if (arguments2.verbose) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector, sourcesFiles);
        }
        if (arguments2.outputFile == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputFile = new File(arguments2.outputFile);
        Config config = K2JSCompiler.getConfig(arguments2, project);
        if (config.checkLibFilesAndReportErrors(new Function1<String, Unit>(){

            @Override
            public Unit invoke(String message) {
                messageCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
                return Unit.INSTANCE$;
            }
        })) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        if (K2JSCompiler.analyzeAndReportErrors(messageCollector, sourcesFiles, config)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputPrefixFile = null;
        if (arguments2.outputPrefix != null && !(outputPrefixFile = new File(arguments2.outputPrefix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.outputPrefix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputPostfixFile = null;
        if (arguments2.outputPostfix != null && !(outputPostfixFile = new File(arguments2.outputPostfix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.outputPostfix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.main);
        K2JSTranslator translator = new K2JSTranslator(config);
        try {
            translationResult = translator.translate(sourcesFiles, mainCallParameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AnalyzerWithCompilerReport.reportDiagnostics(translationResult.getDiagnostics(), messageCollector);
        if (!(translationResult instanceof TranslationResult.Success)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputDir = outputFile.getParentFile();
        if (outputDir == null) {
            outputDir = outputFile.getAbsoluteFile().getParentFile();
        }
        OutputUtilsPackage.writeAll(outputFiles, outputDir, messageCollector);
        ExitCode exitCode = ExitCode.OK;
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        return exitCode;
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector, @NotNull List<JetFile> sourceFiles) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        List<String> fileNames = ContainerUtil.map(sourceFiles, new Function<JetFile, String>(){

            @Override
            public String fun(@Nullable JetFile file) {
                assert (file != null);
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null) {
                    return FileUtil.toSystemDependentName(virtualFile.getPath());
                }
                return file.getName() + "(no virtual file)";
            }
        });
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + Joiner.on(", ").join(fileNames), CompilerMessageLocation.NO_LOCATION);
    }

    private static boolean analyzeAndReportErrors(@NotNull MessageCollector messageCollector, final @NotNull List<JetFile> sources, final @NotNull Config config) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector);
        analyzerWithCompilerReport.analyzeAndReport(sources, new Function0<AnalysisResult>(){

            @Override
            public AnalysisResult invoke() {
                return TopDownAnalyzerFacadeForJS.analyzeFiles(sources, Predicates.<PsiFile>alwaysTrue(), config);
            }
        });
        return analyzerWithCompilerReport.hasErrors();
    }

    @NotNull
    private static Config getConfig(@NotNull K2JSCompilerArguments arguments2, @NotNull Project project) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "getConfig"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "getConfig"));
        }
        if (arguments2.target != null) assert (arguments2.target == "v5") : "Unsupported ECMA version: " + arguments2.target;
        EcmaVersion ecmaVersion = EcmaVersion.defaultVersion();
        String moduleId = FileUtil.getNameWithoutExtension(new File(arguments2.outputFile));
        boolean inlineEnabled = !arguments2.noInline;
        SmartList<String> libraryFiles = new SmartList<String>();
        if (!arguments2.noStdlib) {
            libraryFiles.add(0, PathUtil.getKotlinPathsForCompiler().getJsStdLibJarPath().getAbsolutePath());
        }
        if (arguments2.libraryFiles != null) {
            ContainerUtil.addAllNotNull(libraryFiles, arguments2.libraryFiles);
        }
        LibrarySourcesConfig librarySourcesConfig = new LibrarySourcesConfig(project, moduleId, libraryFiles, ecmaVersion, arguments2.sourceMap, inlineEnabled);
        if (librarySourcesConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "getConfig"));
        }
        return librarySourcesConfig;
    }

    public static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }
}

