/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.KObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.BlockInfo;
import org.jetbrains.kotlin.cfg.BreakableBlockInfo;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.JetControlFlowBuilder;
import org.jetbrains.kotlin.cfg.JetControlFlowBuilderAdapter;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.pseudocode.AllTypes;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactory;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactoryImpl;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodePackage;
import org.jetbrains.kotlin.cfg.pseudocode.SingleType;
import org.jetbrains.kotlin.cfg.pseudocode.TypePredicate;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.OperationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ThrowExceptionInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;

public class JetControlFlowInstructionsGenerator
extends JetControlFlowBuilderAdapter {
    private JetControlFlowBuilder builder = null;
    private final Stack<LoopInfo> loopInfo = new Stack();
    private final Stack<LexicalScope> lexicalScopes = new Stack();
    private final Map<JetElement, BreakableBlockInfo> elementToBlockInfo = new HashMap<JetElement, BreakableBlockInfo>();
    private int labelCount = 0;
    private final Stack<JetControlFlowInstructionsGeneratorWorker> builders = new Stack();
    private final Stack<BlockInfo> allBlocks = new Stack();

    @Override
    @NotNull
    protected JetControlFlowBuilder getDelegateBuilder() {
        JetControlFlowBuilder jetControlFlowBuilder = this.builder;
        if (jetControlFlowBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "getDelegateBuilder"));
        }
        return jetControlFlowBuilder;
    }

    private void pushBuilder(JetElement scopingElement, JetElement subroutine) {
        JetControlFlowInstructionsGeneratorWorker worker = new JetControlFlowInstructionsGeneratorWorker(scopingElement, subroutine);
        this.builders.push(worker);
        this.builder = worker;
    }

    private JetControlFlowInstructionsGeneratorWorker popBuilder(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "popBuilder"));
        }
        JetControlFlowInstructionsGeneratorWorker worker = this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (JetControlFlowBuilder)this.builders.peek() : null;
        return worker;
    }

    @Override
    public void enterSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "enterSubroutine"));
        }
        if (this.builder != null && subroutine instanceof JetFunctionLiteral) {
            this.pushBuilder(subroutine, this.builder.getReturnSubroutine());
        } else {
            this.pushBuilder(subroutine, subroutine);
        }
        assert (this.builder != null);
        this.builder.enterLexicalScope(subroutine);
        this.builder.enterSubroutine(subroutine);
    }

    @Override
    @NotNull
    public Pseudocode exitSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        super.exitSubroutine(subroutine);
        this.builder.exitLexicalScope(subroutine);
        JetControlFlowInstructionsGeneratorWorker worker = this.popBuilder(subroutine);
        if (!this.builders.empty()) {
            JetControlFlowInstructionsGeneratorWorker builder = this.builders.peek();
            builder.declareFunction(subroutine, worker.getPseudocode());
        }
        PseudocodeImpl pseudocodeImpl = worker.getPseudocode();
        if (pseudocodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        return pseudocodeImpl;
    }

    public static class TryFinallyBlockInfo
    extends BlockInfo {
        private final GenerationTrigger finallyBlock;

        private TryFinallyBlockInfo(GenerationTrigger finallyBlock) {
            this.finallyBlock = finallyBlock;
        }

        public void generateFinallyBlock() {
            this.finallyBlock.generate();
        }
    }

    private class JetControlFlowInstructionsGeneratorWorker
    implements JetControlFlowBuilder {
        private final PseudocodeImpl pseudocode;
        private final Label error;
        private final Label sink;
        private final JetElement returnSubroutine;
        private final PseudoValueFactory valueFactory;

        private JetControlFlowInstructionsGeneratorWorker(@NotNull JetElement scopingElement, @NotNull JetElement returnSubroutine) {
            if (scopingElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopingElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            if (returnSubroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnSubroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            this.valueFactory = new PseudoValueFactoryImpl(){

                @Override
                @NotNull
                public PseudoValue newValue(@Nullable JetElement element, @Nullable InstructionWithValue instruction) {
                    PseudoValue value = super.newValue(element, instruction);
                    if (element != null) {
                        JetControlFlowInstructionsGeneratorWorker.this.bindValue(value, element);
                    }
                    PseudoValue pseudoValue = value;
                    if (pseudoValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker$1", "newValue"));
                    }
                    return pseudoValue;
                }
            };
            this.pseudocode = new PseudocodeImpl(scopingElement);
            this.error = this.pseudocode.createLabel("error", null);
            this.sink = this.pseudocode.createLabel("sink", null);
            this.returnSubroutine = returnSubroutine;
        }

        public PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private void add(@NotNull Instruction instruction) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "add"));
            }
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public final Label createUnboundLabel() {
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++, null);
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        @NotNull
        public Label createUnboundLabel(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++, name);
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        @NotNull
        public final LoopInfo enterLoop(@NotNull JetLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoop"));
            }
            LoopInfo info = new LoopInfo(expression, this.createUnboundLabel("loop entry point"), this.createUnboundLabel("loop exit point"), this.createUnboundLabel("body entry point"), this.createUnboundLabel("body exit point"), this.createUnboundLabel("condition entry point"));
            this.bindLabel(info.getEntryPoint());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(expression, info);
            LoopInfo loopInfo = info;
            if (loopInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoop"));
            }
            return loopInfo;
        }

        @Override
        public void enterLoopBody(@NotNull JetLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoopBody"));
            }
            LoopInfo info = (LoopInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(expression);
            this.bindLabel(info.getBodyEntryPoint());
            JetControlFlowInstructionsGenerator.this.loopInfo.push(info);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(info);
        }

        @Override
        public final void exitLoopBody(@NotNull JetLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitLoopBody"));
            }
            LoopInfo info = (LoopInfo)JetControlFlowInstructionsGenerator.this.loopInfo.pop();
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(expression);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            this.bindLabel(info.getBodyExitPoint());
        }

        @Override
        public JetLoopExpression getCurrentLoop() {
            return JetControlFlowInstructionsGenerator.this.loopInfo.empty() ? null : ((LoopInfo)JetControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull JetElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterSubroutine"));
            }
            BreakableBlockInfo blockInfo = new BreakableBlockInfo(subroutine, this.createUnboundLabel(), this.createUnboundLabel());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(subroutine, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.bindLabel(blockInfo.getEntryPoint());
            this.add(new SubroutineEnterInstruction(subroutine, this.getCurrentScope()));
        }

        @Override
        @NotNull
        public JetElement getCurrentSubroutine() {
            JetElement jetElement = this.pseudocode.getCorrespondingElement();
            if (jetElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getCurrentSubroutine"));
            }
            return jetElement;
        }

        @Override
        public JetElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        @Override
        @NotNull
        public Label getEntryPoint(@NotNull JetElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            Label label = ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement)).getEntryPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            return label;
        }

        @Override
        @NotNull
        public Label getConditionEntryPoint(@NotNull JetElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getConditionEntryPoint"));
            }
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo instanceof LoopInfo) : "expected LoopInfo for " + labelElement.getText();
            Label label = ((LoopInfo)blockInfo).getConditionEntryPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getConditionEntryPoint"));
            }
            return label;
        }

        @Override
        @NotNull
        public Label getExitPoint(@NotNull JetElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo != null) : labelElement.getText();
            Label label = blockInfo.getExitPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            return label;
        }

        @NotNull
        private LexicalScope getCurrentScope() {
            LexicalScope lexicalScope = (LexicalScope)JetControlFlowInstructionsGenerator.this.lexicalScopes.peek();
            if (lexicalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getCurrentScope"));
            }
            return lexicalScope;
        }

        @Override
        public void enterLexicalScope(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLexicalScope"));
            }
            LexicalScope current = JetControlFlowInstructionsGenerator.this.lexicalScopes.isEmpty() ? null : this.getCurrentScope();
            LexicalScope scope2 = new LexicalScope(current, element);
            JetControlFlowInstructionsGenerator.this.lexicalScopes.push(scope2);
        }

        @Override
        public void exitLexicalScope(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitLexicalScope"));
            }
            LexicalScope currentScope = this.getCurrentScope();
            assert (currentScope.getElement() == element) : "Exit from not the current lexical scope.\nCurrent scope is for: " + currentScope.getElement() + ".\n" + "Exit from the scope for: " + element.getText();
            JetControlFlowInstructionsGenerator.this.lexicalScopes.pop();
        }

        private void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<TryFinallyBlockInfo> finallyBlocks = new ArrayList<TryFinallyBlockInfo>();
            for (int i = JetControlFlowInstructionsGenerator.this.allBlocks.size() - 1; i >= 0; --i) {
                BlockInfo blockInfo = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.get(i);
                if (blockInfo instanceof BreakableBlockInfo) {
                    BreakableBlockInfo breakableBlockInfo = (BreakableBlockInfo)blockInfo;
                    if (!breakableBlockInfo.getReferablePoints().contains(jumpTarget) && jumpTarget != this.error) continue;
                    for (int j = finallyBlocks.size() - 1; j >= 0; --j) {
                        ((TryFinallyBlockInfo)finallyBlocks.get(j)).generateFinallyBlock();
                    }
                    break;
                }
                if (!(blockInfo instanceof TryFinallyBlockInfo)) continue;
                TryFinallyBlockInfo tryFinallyBlockInfo = (TryFinallyBlockInfo)blockInfo;
                finallyBlocks.add(tryFinallyBlockInfo);
            }
        }

        @Override
        @NotNull
        public Pseudocode exitSubroutine(@NotNull JetElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            this.bindLabel(this.getExitPoint(subroutine));
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), false));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), true));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, this.getCurrentScope(), "<SINK>"));
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(subroutine);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            PseudocodeImpl pseudocodeImpl = this.pseudocode;
            if (pseudocodeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            return pseudocodeImpl;
        }

        @Override
        public void mark(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "mark"));
            }
            this.add(new MarkInstruction(element, this.getCurrentScope()));
        }

        @Override
        @Nullable
        public PseudoValue getBoundValue(@Nullable JetElement element) {
            return this.pseudocode.getElementValue(element);
        }

        @Override
        public void bindValue(@NotNull PseudoValue value, @NotNull JetElement element) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindValue"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindValue"));
            }
            this.pseudocode.bindElementToValue(element, value);
        }

        @Override
        @NotNull
        public PseudoValue newValue(@Nullable JetElement element) {
            PseudoValue pseudoValue = this.valueFactory.newValue(element, null);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "newValue"));
            }
            return pseudoValue;
        }

        @Override
        public void returnValue(@NotNull JetExpression returnExpression, @NotNull PseudoValue returnValue, @NotNull JetElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            if (returnValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, this.getCurrentScope(), exitPoint, returnValue));
        }

        @Override
        public void returnNoValue(@NotNull JetReturnExpression returnExpression, @NotNull JetElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction((JetElement)returnExpression, this.getCurrentScope(), exitPoint));
        }

        @Override
        public void write(@NotNull JetElement assignment, @NotNull JetElement lValue, @NotNull PseudoValue rValue, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (lValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (rValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            this.add(new WriteValueInstruction(assignment, this.getCurrentScope(), target, receiverValues, lValue, rValue));
        }

        @Override
        public void declareParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareParameter"));
            }
            this.add(new VariableDeclarationInstruction(parameter, this.getCurrentScope()));
        }

        @Override
        public void declareVariable(@NotNull JetVariableDeclaration property2) {
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareVariable"));
            }
            this.add(new VariableDeclarationInstruction(property2, this.getCurrentScope()));
        }

        @Override
        public void declareFunction(@NotNull JetElement subroutine, @NotNull Pseudocode pseudocode) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            if (pseudocode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            this.add(new LocalFunctionDeclarationInstruction(subroutine, pseudocode, this.getCurrentScope()));
        }

        @Override
        public void loadUnit(@NotNull JetExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadUnit"));
            }
            this.add(new LoadUnitValueInstruction(expression, this.getCurrentScope()));
        }

        @Override
        public void jump(@NotNull Label label, @NotNull JetElement element) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(element, label, this.getCurrentScope()));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label, @NotNull JetElement element, @Nullable PseudoValue conditionValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnFalse"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnFalse"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, false, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label, @NotNull JetElement element, @Nullable PseudoValue conditionValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnTrue"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnTrue"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, true, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindLabel"));
            }
            this.pseudocode.bindLabel(label);
        }

        @Override
        public void nondeterministicJump(@NotNull Label label, @NotNull JetElement element, @Nullable PseudoValue inputValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(element, Collections.singletonList(label), this.getCurrentScope(), inputValue));
        }

        @Override
        public void nondeterministicJump(@NotNull List<Label> labels, @NotNull JetElement element) {
            if (labels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.add(new NondeterministicJumpInstruction(element, labels, this.getCurrentScope(), null));
        }

        @Override
        public void jumpToError(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpToError"));
            }
            this.handleJumpInsideTryFinally(this.error);
            this.add(new UnconditionalJumpInstruction(element, this.error, this.getCurrentScope()));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger generationTrigger) {
            if (generationTrigger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationTrigger", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterTryFinally"));
            }
            JetControlFlowInstructionsGenerator.this.allBlocks.push(new TryFinallyBlockInfo(generationTrigger));
        }

        @Override
        public void throwException(@NotNull JetThrowExpression expression, @NotNull PseudoValue thrownValue) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "throwException"));
            }
            if (thrownValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "throwException"));
            }
            this.handleJumpInsideTryFinally(this.error);
            this.add(new ThrowExceptionInstruction(expression, this.getCurrentScope(), this.error, thrownValue));
        }

        @Override
        public void exitTryFinally() {
            BlockInfo pop = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            assert (pop instanceof TryFinallyBlockInfo);
        }

        @Override
        public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
            if (startLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            if (finishLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            JetControlFlowInstructionsGenerator.this.labelCount = this.pseudocode.repeatPart(startLabel, finishLabel, JetControlFlowInstructionsGenerator.this.labelCount);
        }

        @Override
        @NotNull
        public InstructionWithValue loadConstant(@NotNull JetExpression expression, @Nullable CompileTimeConstant<?> constant) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadConstant"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadConstant"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue createAnonymousObject(@NotNull JetObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createAnonymousObject"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createAnonymousObject"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue createFunctionLiteral(@NotNull JetFunctionLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createFunctionLiteral"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createFunctionLiteral"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue loadStringTemplate(@NotNull JetStringTemplateExpression expression, @NotNull List<PseudoValue> inputValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            if (inputValues.isEmpty()) {
                ReadValueInstruction readValueInstruction = this.read(expression);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
                }
                return readValueInstruction;
            }
            Map<PseudoValue, TypePredicate> predicate = PseudocodePackage.expectedTypeFor(AllTypes.INSTANCE$, inputValues);
            MagicInstruction magicInstruction = this.magic(expression, expression, inputValues, predicate, MagicKind.STRING_TEMPLATE);
            if (magicInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            return magicInstruction;
        }

        @Override
        @NotNull
        public MagicInstruction magic(@NotNull JetElement instructionElement, @Nullable JetElement valueElement, @NotNull List<PseudoValue> inputValues, @NotNull Map<PseudoValue, TypePredicate> expectedTypes, @NotNull MagicKind kind) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            if (expectedTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            MagicInstruction instruction = MagicInstruction.Factory.create(instructionElement, valueElement, this.getCurrentScope(), inputValues, expectedTypes, kind, this.valueFactory);
            this.add(instruction);
            MagicInstruction magicInstruction = instruction;
            if (magicInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            return magicInstruction;
        }

        @Override
        @NotNull
        public MergeInstruction merge(@NotNull JetExpression expression, @NotNull List<PseudoValue> inputValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            MergeInstruction instruction = MergeInstruction.Factory.create(expression, this.getCurrentScope(), inputValues, this.valueFactory);
            this.add(instruction);
            MergeInstruction mergeInstruction = instruction;
            if (mergeInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            return mergeInstruction;
        }

        @Override
        @NotNull
        public ReadValueInstruction readVariable(@NotNull JetExpression expression, @NotNull ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression, resolvedCall, receiverValues);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public CallInstruction call(@NotNull JetElement valueElement, @NotNull ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues, @NotNull Map<PseudoValue, ValueParameterDescriptor> arguments2) {
            if (valueElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            JetType returnType = resolvedCall.getResultingDescriptor().getReturnType();
            CallInstruction instruction = CallInstruction.Factory.create(valueElement, this.getCurrentScope(), resolvedCall, receiverValues, arguments2, (PseudoValueFactory)(returnType != null && KotlinBuiltIns.isNothing(returnType) ? null : this.valueFactory));
            this.add(instruction);
            CallInstruction callInstruction = instruction;
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            return callInstruction;
        }

        @Override
        @NotNull
        public OperationInstruction predefinedOperation(@NotNull JetExpression expression, @NotNull JetControlFlowBuilder.PredefinedOperation operation, @NotNull List<PseudoValue> inputValues) {
            Map<PseudoValue, TypePredicate> expectedTypes;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            switch (operation) {
                case AND: 
                case OR: {
                    SingleType onlyBoolean = new SingleType(KotlinBuiltIns.getInstance().getBooleanType());
                    expectedTypes = PseudocodePackage.expectedTypeFor(onlyBoolean, inputValues);
                    break;
                }
                case NOT_NULL_ASSERTION: {
                    expectedTypes = PseudocodePackage.expectedTypeFor(AllTypes.INSTANCE$, inputValues);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
                }
            }
            MagicInstruction magicInstruction = this.magic(expression, expression, inputValues, expectedTypes, this.getMagicKind(operation));
            if (magicInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            return magicInstruction;
        }

        @NotNull
        private MagicKind getMagicKind(@NotNull JetControlFlowBuilder.PredefinedOperation operation) {
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
            }
            switch (operation) {
                case AND: {
                    MagicKind magicKind = MagicKind.AND;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
                case OR: {
                    MagicKind magicKind = MagicKind.OR;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
                case NOT_NULL_ASSERTION: {
                    MagicKind magicKind = MagicKind.NOT_NULL_ASSERTION;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
            }
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
        }

        @NotNull
        private ReadValueInstruction read(@NotNull JetExpression expression, @Nullable ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            KObject accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE$;
            ReadValueInstruction instruction = ReadValueInstruction.Factory.create(expression, this.getCurrentScope(), (AccessTarget)((Object)accessTarget), (Map<PseudoValue, ? extends ReceiverValue>)receiverValues, this.valueFactory);
            this.add(instruction);
            ReadValueInstruction readValueInstruction = instruction;
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            return readValueInstruction;
        }

        @NotNull
        private ReadValueInstruction read(@NotNull JetExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression, null, Collections.<PseudoValue, ReceiverValue>emptyMap());
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            return readValueInstruction;
        }
    }
}

