/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.InstructionDataMergeStrategy;
import org.jetbrains.kotlin.cfg.LexicalScopeVariableInfo;
import org.jetbrains.kotlin.cfg.PseudocodeVariableDataCollector;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserPackage;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

public class PseudocodeVariablesData {
    private final Pseudocode pseudocode;
    private final BindingContext bindingContext;
    private final PseudocodeVariableDataCollector pseudocodeVariableDataCollector;
    private final Map<Pseudocode, Set<VariableDescriptor>> declaredVariablesForDeclaration;
    private final Map<Pseudocode, Set<VariableDescriptor>> usedVariablesForDeclaration;
    private Map<Instruction, Edges<Map<VariableDescriptor, VariableInitState>>> variableInitializers;

    public PseudocodeVariablesData(@NotNull Pseudocode pseudocode, @NotNull BindingContext bindingContext) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "<init>"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "<init>"));
        }
        this.declaredVariablesForDeclaration = Maps.newHashMap();
        this.usedVariablesForDeclaration = Maps.newHashMap();
        this.pseudocode = pseudocode;
        this.bindingContext = bindingContext;
        this.pseudocodeVariableDataCollector = new PseudocodeVariableDataCollector(bindingContext, pseudocode);
    }

    @NotNull
    public Pseudocode getPseudocode() {
        Pseudocode pseudocode = this.pseudocode;
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getPseudocode"));
        }
        return pseudocode;
    }

    @NotNull
    public LexicalScopeVariableInfo getLexicalScopeVariableInfo() {
        LexicalScopeVariableInfo lexicalScopeVariableInfo = this.pseudocodeVariableDataCollector.getLexicalScopeVariableInfo();
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getLexicalScopeVariableInfo"));
        }
        return lexicalScopeVariableInfo;
    }

    @NotNull
    public Set<VariableDescriptor> getUsedVariables(@NotNull Pseudocode pseudocode) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUsedVariables"));
        }
        Set<VariableDescriptor> usedVariables = this.usedVariablesForDeclaration.get(pseudocode);
        if (usedVariables == null) {
            final HashSet result2 = Sets.newHashSet();
            PseudocodeTraverserPackage.traverse(pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends Unit>)new Function1<Instruction, Unit>(){

                @Override
                public Unit invoke(@NotNull Instruction instruction) {
                    if (instruction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$1", "invoke"));
                    }
                    VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, PseudocodeVariablesData.this.bindingContext);
                    if (variableDescriptor != null) {
                        result2.add(variableDescriptor);
                    }
                    return Unit.INSTANCE$;
                }
            });
            usedVariables = Collections.unmodifiableSet(result2);
            this.usedVariablesForDeclaration.put(pseudocode, usedVariables);
        }
        Set<VariableDescriptor> set = usedVariables;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUsedVariables"));
        }
        return set;
    }

    @NotNull
    public Set<VariableDescriptor> getDeclaredVariables(@NotNull Pseudocode pseudocode, boolean includeInsideLocalDeclarations) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
        }
        if (!includeInsideLocalDeclarations) {
            Set<VariableDescriptor> set = this.getUpperLevelDeclaredVariables(pseudocode);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
            }
            return set;
        }
        HashSet<VariableDescriptor> declaredVariables = Sets.newHashSet();
        declaredVariables.addAll(this.getUpperLevelDeclaredVariables(pseudocode));
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            Pseudocode localPseudocode = localFunctionDeclarationInstruction.getBody();
            declaredVariables.addAll(this.getUpperLevelDeclaredVariables(localPseudocode));
        }
        HashSet<VariableDescriptor> hashSet = declaredVariables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VariableDescriptor> getUpperLevelDeclaredVariables(@NotNull Pseudocode pseudocode) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUpperLevelDeclaredVariables"));
        }
        Set<VariableDescriptor> declaredVariables = this.declaredVariablesForDeclaration.get(pseudocode);
        if (declaredVariables == null) {
            declaredVariables = this.computeDeclaredVariablesForPseudocode(pseudocode);
            this.declaredVariablesForDeclaration.put(pseudocode, declaredVariables);
        }
        Set<VariableDescriptor> set = declaredVariables;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUpperLevelDeclaredVariables"));
        }
        return set;
    }

    @NotNull
    private Set<VariableDescriptor> computeDeclaredVariablesForPseudocode(Pseudocode pseudocode) {
        HashSet<VariableDescriptor> declaredVariables = Sets.newHashSet();
        for (Instruction instruction : pseudocode.getInstructions()) {
            JetDeclaration variableDeclarationElement;
            DeclarationDescriptor descriptor;
            if (!(instruction instanceof VariableDeclarationInstruction) || (descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement())) == null) continue;
            assert (descriptor instanceof VariableDescriptor);
            declaredVariables.add((VariableDescriptor)descriptor);
        }
        Set<VariableDescriptor> set = Collections.unmodifiableSet(declaredVariables);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "computeDeclaredVariablesForPseudocode"));
        }
        return set;
    }

    @NotNull
    public Map<Instruction, Edges<Map<VariableDescriptor, VariableInitState>>> getVariableInitializers() {
        if (this.variableInitializers == null) {
            this.variableInitializers = this.computeVariableInitializers();
        }
        Map<Instruction, Edges<Map<VariableDescriptor, VariableInitState>>> map = this.variableInitializers;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getVariableInitializers"));
        }
        return map;
    }

    @NotNull
    private Map<Instruction, Edges<Map<VariableDescriptor, VariableInitState>>> computeVariableInitializers() {
        final LexicalScopeVariableInfo lexicalScopeVariableInfo = this.pseudocodeVariableDataCollector.getLexicalScopeVariableInfo();
        Map<Instruction, Edges<Map<VariableDescriptor, VariableInitState>>> map = this.pseudocodeVariableDataCollector.collectData(TraversalOrder.FORWARD, false, new InstructionDataMergeStrategy<VariableInitState>(){

            @Override
            @NotNull
            public Edges<Map<VariableDescriptor, VariableInitState>> invoke(@NotNull Instruction instruction, @NotNull Collection<? extends Map<VariableDescriptor, VariableInitState>> incomingEdgesData) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                if (incomingEdgesData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                Map enterInstructionData = PseudocodeVariablesData.mergeIncomingEdgesDataForInitializers(incomingEdgesData);
                Map exitInstructionData = PseudocodeVariablesData.this.addVariableInitStateFromCurrentInstructionIfAny(instruction, enterInstructionData, lexicalScopeVariableInfo);
                Edges<Map<VariableDescriptor, VariableInitState>> edges = new Edges<Map<VariableDescriptor, VariableInitState>>(enterInstructionData, exitInstructionData);
                if (edges == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                return edges;
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "computeVariableInitializers"));
        }
        return map;
    }

    public static VariableInitState getDefaultValueForInitializers(@NotNull VariableDescriptor variable, @NotNull Instruction instruction, @NotNull LexicalScopeVariableInfo lexicalScopeVariableInfo) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScopeVariableInfo", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        LexicalScope declaredIn = lexicalScopeVariableInfo.getDeclaredIn().get(variable);
        boolean declaredOutsideThisDeclaration = declaredIn == null || declaredIn.getLexicalScopeForContainingDeclaration() != instruction.getLexicalScope().getLexicalScopeForContainingDeclaration();
        return VariableInitState.create(declaredOutsideThisDeclaration);
    }

    @NotNull
    private static Map<VariableDescriptor, VariableInitState> mergeIncomingEdgesDataForInitializers(@NotNull Collection<? extends Map<VariableDescriptor, VariableInitState>> incomingEdgesData) {
        if (incomingEdgesData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "mergeIncomingEdgesDataForInitializers"));
        }
        HashSet<VariableDescriptor> variablesInScope = Sets.newHashSet();
        for (Map<VariableDescriptor, VariableInitState> map : incomingEdgesData) {
            variablesInScope.addAll(map.keySet());
        }
        HashMap<VariableDescriptor, VariableInitState> enterInstructionData = Maps.newHashMap();
        for (VariableDescriptor variable : variablesInScope) {
            boolean isInitialized = true;
            boolean isDeclared = true;
            for (Map<VariableDescriptor, VariableInitState> map : incomingEdgesData) {
                VariableInitState initState = map.get(variable);
                if (initState == null) continue;
                if (!initState.isInitialized) {
                    isInitialized = false;
                }
                if (initState.isDeclared) continue;
                isDeclared = false;
            }
            enterInstructionData.put(variable, VariableInitState.create(isInitialized, isDeclared));
        }
        HashMap<VariableDescriptor, VariableInitState> hashMap = enterInstructionData;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "mergeIncomingEdgesDataForInitializers"));
        }
        return hashMap;
    }

    @NotNull
    private Map<VariableDescriptor, VariableInitState> addVariableInitStateFromCurrentInstructionIfAny(@NotNull Instruction instruction, @NotNull Map<VariableDescriptor, VariableInitState> enterInstructionData, @NotNull LexicalScopeVariableInfo lexicalScopeVariableInfo) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (enterInstructionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enterInstructionData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScopeVariableInfo", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (!(instruction instanceof WriteValueInstruction) && !(instruction instanceof VariableDeclarationInstruction)) {
            Map<VariableDescriptor, VariableInitState> map = enterInstructionData;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
            }
            return map;
        }
        VariableDescriptor variable = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, this.bindingContext);
        if (variable == null) {
            Map<VariableDescriptor, VariableInitState> map = enterInstructionData;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
            }
            return map;
        }
        HashMap<VariableDescriptor, VariableInitState> exitInstructionData = Maps.newHashMap(enterInstructionData);
        if (instruction instanceof WriteValueInstruction) {
            VariableInitState enterInitState = enterInstructionData.get(variable);
            VariableInitState initializationAtThisElement = VariableInitState.create(((WriteValueInstruction)instruction).getElement() instanceof JetProperty, enterInitState);
            exitInstructionData.put(variable, initializationAtThisElement);
        } else {
            VariableInitState enterInitState = enterInstructionData.get(variable);
            if (enterInitState == null) {
                enterInitState = PseudocodeVariablesData.getDefaultValueForInitializers(variable, instruction, lexicalScopeVariableInfo);
            }
            if (enterInitState == null || !enterInitState.isInitialized || !enterInitState.isDeclared) {
                boolean isInitialized = enterInitState != null && enterInitState.isInitialized;
                VariableInitState variableDeclarationInfo = VariableInitState.create(isInitialized, true);
                exitInstructionData.put(variable, variableDeclarationInfo);
            }
        }
        HashMap<VariableDescriptor, VariableInitState> hashMap = exitInstructionData;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        return hashMap;
    }

    @NotNull
    public Map<Instruction, Edges<Map<VariableDescriptor, VariableUseState>>> getVariableUseStatusData() {
        Map<Instruction, Edges<Map<VariableDescriptor, VariableUseState>>> map = this.pseudocodeVariableDataCollector.collectData(TraversalOrder.BACKWARD, true, new InstructionDataMergeStrategy<VariableUseState>(){

            @Override
            @NotNull
            public Edges<Map<VariableDescriptor, VariableUseState>> invoke(@NotNull Instruction instruction, @NotNull Collection<? extends Map<VariableDescriptor, VariableUseState>> incomingEdgesData) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$3", "invoke"));
                }
                if (incomingEdgesData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$3", "invoke"));
                }
                HashMap<VariableDescriptor, VariableUseState> enterResult = Maps.newHashMap();
                for (Map<VariableDescriptor, VariableUseState> map : incomingEdgesData) {
                    for (Map.Entry<VariableDescriptor, VariableUseState> entry : map.entrySet()) {
                        VariableDescriptor variableDescriptor = entry.getKey();
                        VariableUseState variableUseState = entry.getValue();
                        enterResult.put(variableDescriptor, variableUseState.merge((VariableUseState)((Object)enterResult.get(variableDescriptor))));
                    }
                }
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, PseudocodeVariablesData.this.bindingContext);
                if (variableDescriptor == null || !(instruction instanceof ReadValueInstruction) && !(instruction instanceof WriteValueInstruction)) {
                    Edges<Map<VariableDescriptor, VariableUseState>> edges = new Edges<Map<VariableDescriptor, VariableUseState>>(enterResult, enterResult);
                    if (edges == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$3", "invoke"));
                    }
                    return edges;
                }
                HashMap<VariableDescriptor, VariableUseState> hashMap = Maps.newHashMap(enterResult);
                if (instruction instanceof ReadValueInstruction) {
                    hashMap.put(variableDescriptor, VariableUseState.READ);
                } else {
                    VariableUseState variableUseState = (VariableUseState)((Object)enterResult.get(variableDescriptor));
                    if (variableUseState == null) {
                        variableUseState = VariableUseState.UNUSED;
                    }
                    switch (variableUseState) {
                        case UNUSED: 
                        case ONLY_WRITTEN_NEVER_READ: {
                            hashMap.put(variableDescriptor, VariableUseState.ONLY_WRITTEN_NEVER_READ);
                            break;
                        }
                        case WRITTEN_AFTER_READ: 
                        case READ: {
                            hashMap.put(variableDescriptor, VariableUseState.WRITTEN_AFTER_READ);
                        }
                    }
                }
                Edges<Map<VariableDescriptor, VariableUseState>> edges = new Edges<Map<VariableDescriptor, VariableUseState>>(enterResult, hashMap);
                if (edges == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$3", "invoke"));
                }
                return edges;
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getVariableUseStatusData"));
        }
        return map;
    }

    public static enum VariableUseState {
        READ(3),
        WRITTEN_AFTER_READ(2),
        ONLY_WRITTEN_NEVER_READ(1),
        UNUSED(0);

        private final int priority;

        private VariableUseState(int priority) {
            this.priority = priority;
        }

        private VariableUseState merge(@Nullable VariableUseState variableUseState) {
            if (variableUseState == null || this.priority > variableUseState.priority) {
                return this;
            }
            return variableUseState;
        }

        public static boolean isUsed(@Nullable VariableUseState variableUseState) {
            return variableUseState != null && variableUseState != UNUSED;
        }
    }

    public static class VariableInitState {
        public final boolean isInitialized;
        public final boolean isDeclared;
        private static final VariableInitState VS_TT = new VariableInitState(true, true);
        private static final VariableInitState VS_TF = new VariableInitState(true, false);
        private static final VariableInitState VS_FT = new VariableInitState(false, true);
        private static final VariableInitState VS_FF = new VariableInitState(false, false);

        private VariableInitState(boolean isInitialized, boolean isDeclared) {
            this.isInitialized = isInitialized;
            this.isDeclared = isDeclared;
        }

        private static VariableInitState create(boolean isInitialized, boolean isDeclared) {
            if (isInitialized) {
                if (isDeclared) {
                    return VS_TT;
                }
                return VS_TF;
            }
            if (isDeclared) {
                return VS_FT;
            }
            return VS_FF;
        }

        private static VariableInitState create(boolean isInitialized) {
            return VariableInitState.create(isInitialized, false);
        }

        private static VariableInitState create(boolean isDeclaredHere, @Nullable VariableInitState mergedEdgesData) {
            return VariableInitState.create(true, isDeclaredHere || mergedEdgesData != null && mergedEdgesData.isDeclared);
        }

        public String toString() {
            if (!this.isInitialized && !this.isDeclared) {
                return "-";
            }
            return (this.isInitialized ? "I" : "") + (this.isDeclared ? "D" : "");
        }
    }
}

