/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.PsiReceiverParameterImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaParameterElementType
extends JavaStubElementType<PsiParameterStub, PsiParameter> {
    public static final TokenSet ID_TYPES = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.THIS_KEYWORD);

    public JavaParameterElementType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "<init>"));
        }
        super(id);
    }

    @Override
    public PsiParameter createPsi(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createParameter(stub);
    }

    @Override
    public PsiParameter createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "createPsi"));
        }
        boolean receiver = node.getElementType() == JavaElementType.RECEIVER_PARAMETER;
        return receiver ? new PsiReceiverParameterImpl(node) : new PsiParameterImpl(node);
    }

    @Override
    public PsiParameterStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        LighterASTNode id = LightTreeUtil.requiredChildOfType(tree, node, ID_TYPES);
        String name = RecordUtil.intern(tree.getCharTable(), id);
        return new PsiParameterStubImpl(parentStub, name, typeInfo, typeInfo.isEllipsis);
    }

    @Override
    public void serialize(@NotNull PsiParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeBoolean(stub.isParameterTypeEllipsis());
    }

    @Override
    @NotNull
    public PsiParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        boolean isEllipsis = dataStream.readBoolean();
        PsiParameterStubImpl psiParameterStubImpl = new PsiParameterStubImpl(parentStub, name, type2, isEllipsis);
        if (psiParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "deserialize"));
        }
        return psiParameterStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiParameterStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "indexStub"));
        }
    }
}

