/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    public static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceUtil.class.getName());

    public static boolean isSecondSearchPossible(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !methodRef.isConstructor() && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef) && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor());
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef, @Nullable MethodSignature signature, boolean varArgs, boolean isStatic, int parametersCount) {
        if (methodRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodRef", "com/intellij/psi/PsiMethodReferenceUtil", "isResolvedBySecondSearch"));
        }
        if (signature == null) {
            return false;
        }
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        PsiType[] functionalMethodParameterTypes = signature.getParameterTypes();
        return (parametersCount + 1 == functionalMethodParameterTypes.length && !varArgs || varArgs && functionalMethodParameterTypes.length > 0 && !isStatic) && PsiMethodReferenceUtil.isSecondSearchPossible(functionalMethodParameterTypes, qualifierResolveResult, methodRef);
    }

    public static boolean isCorrectAssignment(PsiType[] parameterTypes, PsiType[] argTypes, boolean varargs, int offset) {
        int min = Math.min(parameterTypes.length, argTypes.length - offset);
        for (int i = 0; i < min; ++i) {
            PsiType argType = argTypes[i + offset];
            PsiType parameterType = parameterTypes[i];
            parameterType = GenericsUtil.getVariableTypeByExpressionType(parameterType, true);
            if (!(varargs && i == parameterTypes.length - 1 ? !TypeConversionUtil.isAssignable(parameterType, argType) && !TypeConversionUtil.isAssignable(((PsiArrayType)parameterType).getComponentType(), argType) : !TypeConversionUtil.isAssignable(parameterType, argType))) continue;
            return false;
        }
        return !varargs || parameterTypes.length - 1 <= argTypes.length - offset;
    }

    @Nullable
    public static PsiType getQualifierType(PsiMethodReferenceExpression expression) {
        PsiType qualifierType = null;
        PsiTypeElement typeElement = expression.getQualifierType();
        if (typeElement != null) {
            qualifierType = typeElement.getType();
        } else {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiExpression) {
                qualifierType = ((PsiExpression)qualifier).getType();
            }
        }
        if (qualifierType == null) {
            QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(expression);
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            qualifierType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass);
        }
        return qualifierType;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve2;
            PsiType expressionType = PsiMethodReferenceUtil.replaceArrayType(expression.getType(), expression);
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result2.getElement();
            if (containingClass != null) {
                substitutor = result2.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve2 = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve2;
                substitutor = resolveResult.getSubstitutor();
                QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, substitutor, true);
                if (qualifierResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
                }
                return qualifierResolveResult;
            }
        } else {
            PsiType type2;
            PsiClassType.ClassResolveResult result3;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result3 = PsiUtil.resolveGenericsClassInType(type2 = PsiMethodReferenceUtil.replaceArrayType(typeElement.getType(), typeElement))).getElement()) != null) {
                QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, result3.getSubstitutor(), true);
                if (qualifierResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
                }
                return qualifierResolveResult;
            }
        }
        QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, substitutor, false);
        if (qualifierResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
        }
        return qualifierResolveResult;
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/PsiMethodReferenceUtil", "isStaticallyReferenced"));
        }
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiType receiverType, PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        if (receiverType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), PsiMethodReferenceUtil.replaceArrayType(receiverType, containingClass));
    }

    public static PsiType getFirstParameterType(PsiType functionalInterfaceType, PsiElement context2) {
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0) {
            PsiType type2 = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]);
            return type2 != null ? PsiUtil.captureToplevelWildcards(type2, context2) : null;
        }
        return null;
    }

    private static PsiType replaceArrayType(PsiType type2, @NotNull PsiElement context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/PsiMethodReferenceUtil", "replaceArrayType"));
        }
        if (type2 instanceof PsiArrayType) {
            type2 = JavaPsiFacade.getElementFactory(context2.getProject()).getArrayClassType(((PsiArrayType)type2).getComponentType(), PsiUtil.getLanguageLevel(context2));
        }
        return type2;
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2 = methodRef.resolve();
        if (resolve2 == null) {
            return null;
        }
        return PsiMethodReferenceUtil.checkMethodReferenceContext(methodRef, resolve2, methodRef.getFunctionalInterfaceType());
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef, PsiElement resolve2, PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement referenceElement;
        PsiClass containingClass = resolve2 instanceof PsiMethod ? ((PsiMethod)resolve2).getContainingClass() : (PsiClass)resolve2;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isMethodStatic = false;
        boolean receiverReferenced = false;
        boolean isConstructor = true;
        if (resolve2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve2;
            isMethodStatic = method.hasModifierProperty("static");
            isConstructor = method.isConstructor();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            receiverReferenced = PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)) : null, method.isVarArgs(), isMethodStatic, method.getParameterList().getParametersCount());
            if (method.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                return "Abstract method '" + method.getName() + "' cannot be accessed directly";
            }
        }
        if (!receiverReferenced && isStaticSelector && !isMethodStatic && !isConstructor) {
            return "Non-static method cannot be referenced from a static context";
        }
        if (!receiverReferenced && !isStaticSelector && isMethodStatic) {
            return "Static method referenced through non-static qualifier";
        }
        if (receiverReferenced && isStaticSelector && isMethodStatic && !isConstructor) {
            return "Static method referenced through receiver";
        }
        if (isMethodStatic && isStaticSelector && qualifier instanceof PsiTypeElement && (referenceElement = PsiTreeUtil.getChildOfType(qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            return "Parameterized qualifier on static method reference";
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass(containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass, methodRef, true, false)) {
            return "An enclosing instance of type " + PsiFormatUtil.formatClass(outerClass, 1) + " is not in scope";
        }
        return null;
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters;
            for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return "Unexpected wildcard";
            }
        }
        return null;
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result2, PsiType functionalInterfaceType) {
        PsiElement resolve2 = result2.getElement();
        if (resolve2 instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)resolve2).getContainingClass();
            LOG.assertTrue(containingClass != null);
            PsiSubstitutor subst = result2.getSubstitutor();
            PsiClass qContainingClass = PsiMethodReferenceUtil.getQualifierResolveResult(expression).getContainingClass();
            if (qContainingClass != null && PsiMethodReferenceUtil.isReceiverType(PsiMethodReferenceUtil.getFirstParameterType(functionalInterfaceType, expression), qContainingClass, subst)) {
                LOG.assertTrue((subst = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, subst)) != null);
            }
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            PsiType returnType = PsiTypesUtil.patchMethodGetClassReturnType(expression, expression, (PsiMethod)resolve2, null, PsiUtil.getLanguageLevel(expression));
            if (returnType == null) {
                returnType = ((PsiMethod)resolve2).getReturnType();
            }
            PsiType methodReturnType = subst.substitute(returnType);
            if (interfaceReturnType != null && interfaceReturnType != PsiType.VOID) {
                if (methodReturnType == null) {
                    methodReturnType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass, subst);
                }
                if (!TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType, false)) {
                    return "Bad return type in method reference: cannot convert " + methodReturnType.getCanonicalText() + " to " + interfaceReturnType.getCanonicalText();
                }
            }
        }
        return null;
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

