/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.translate.context.TranslationContext;

public final class JsDescriptorUtils {
    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getName().equals(OperatorConventions.COMPARE_TO);
    }

    public static boolean isConstructorDescriptor(@NotNull CallableDescriptor descriptor) {
        return descriptor instanceof ConstructorDescriptor;
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() != ClassKind.CLASS) continue;
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor) {
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor));
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        return containing;
    }

    public static boolean isExtension(@NotNull CallableDescriptor functionDescriptor) {
        return functionDescriptor.getReceiverParameter() != null;
    }

    @Nullable
    public static DeclarationDescriptor getExpectedThisDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor expectedThisObject = callableDescriptor.getExpectedThisObject();
        if (expectedThisObject == null) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(expectedThisObject.getValue());
    }

    @NotNull
    public static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        ClassifierDescriptor declarationDescriptor = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        return declarationDescriptor.getOriginal();
    }

    @Nullable
    public static DeclarationDescriptor getExpectedReceiverDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        if (receiverParameter == null) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter.getValue());
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor) {
        for (DeclarationDescriptor containing = descriptor.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor) || DescriptorUtils.isClassObject(containing)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    @Nullable
    public static FunctionDescriptor getOverriddenDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        Set<? extends FunctionDescriptor> overriddenDescriptors = functionDescriptor.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return null;
        }
        return overriddenDescriptors.iterator().next();
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault();
    }

    public static boolean isAsPrivate(@NotNull PropertyDescriptor propertyDescriptor) {
        return JsDescriptorUtils.isExtension(propertyDescriptor) || !JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) || !JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter());
    }

    public static boolean isStandardDeclaration(@NotNull DeclarationDescriptor descriptor) {
        NamespaceDescriptor namespace = JsDescriptorUtils.getContainingNamespace(descriptor);
        if (namespace == null) {
            return false;
        }
        return namespace.equals(KotlinBuiltIns.getInstance().getBuiltInsScope().getContainingDeclaration());
    }

    @Nullable
    public static NamespaceDescriptor getContainingNamespace(@NotNull DeclarationDescriptor descriptor) {
        return DescriptorUtils.getParentOfType(descriptor, NamespaceDescriptor.class);
    }

    @Nullable
    public static Name getNameIfStandardType(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        JetType type = context.bindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
        return type != null ? JsDescriptorUtils.getNameIfStandardType(type) : null;
    }

    @Nullable
    public static Name getNameIfStandardType(@NotNull JetType type) {
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && descriptor.getContainingDeclaration() == KotlinBuiltIns.getInstance().getBuiltInsPackage()) {
            return descriptor.getName();
        }
        return null;
    }

    @NotNull
    public static DeclarationDescriptor getDeclarationDescriptorForExtensionCallReceiver(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        ReceiverValue receiverArgument = resolvedCall.getReceiverArgument();
        if (receiverArgument instanceof ExtensionReceiver) {
            return ((ExtensionReceiver)receiverArgument).getDeclarationDescriptor();
        }
        if (receiverArgument instanceof ClassReceiver) {
            return ((ClassReceiver)receiverArgument).getDeclarationDescriptor();
        }
        throw new IllegalStateException("Unexpected receiver of type " + receiverArgument.getClass());
    }
}

