/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class NativePropertyAccessTranslator
extends PropertyAccessTranslator {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final PropertyDescriptor propertyDescriptor;

    NativePropertyAccessTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        super(context);
        this.receiver = receiver;
        this.propertyDescriptor = descriptor.getOriginal();
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.getReceiver());
    }

    @Override
    @NotNull
    protected JsExpression translateAsGet(@Nullable JsExpression receiver) {
        return this.getCallType().constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                return NativePropertyAccessTranslator.this.doTranslateAsGet(receiver);
            }
        }, this.context());
    }

    @NotNull
    private JsExpression doTranslateAsGet(JsExpression receiver) {
        JsName nativePropertyName = this.context().getNameForDescriptor(this.propertyDescriptor);
        if (receiver != null) {
            return new JsNameRef(nativePropertyName, receiver);
        }
        return nativePropertyName.makeRef();
    }

    @Override
    @NotNull
    protected JsExpression translateAsSet(@Nullable JsExpression receiver, final @NotNull JsExpression setTo) {
        assert (receiver != null);
        return this.getCallType().constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                return JsAstUtils.assignment(NativePropertyAccessTranslator.this.translateAsGet(receiver), setTo);
            }
        }, this.context());
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return this.translateAsSet(this.getReceiver(), setTo);
    }

    @Nullable
    private JsExpression getReceiver() {
        if (this.receiver != null) {
            return this.receiver;
        }
        assert (this.propertyDescriptor.getReceiverParameter() == null) : "Can't have native extension properties.";
        DeclarationDescriptor expectedThisDescriptor = JsDescriptorUtils.getExpectedThisDescriptor(this.propertyDescriptor);
        if (expectedThisDescriptor == null) {
            return null;
        }
        return this.context().getThisObject(expectedThisDescriptor);
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return new CachedPropertyAccessTranslator(this.getReceiver(), this, this.context());
    }
}

