/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class CallParametersResolver {
    @Nullable
    private final JsExpression qualifier;
    @Nullable
    private final JsExpression callee;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final ResolvedCall<? extends CallableDescriptor> resolvedCall;
    private final boolean isExtensionCall;

    public static CallParameters resolveCallParameters(@Nullable JsExpression qualifier, @Nullable JsExpression callee, @NotNull CallableDescriptor descriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull TranslationContext context) {
        return new CallParametersResolver(qualifier, callee, descriptor, call, context).resolve();
    }

    private CallParametersResolver(@Nullable JsExpression qualifier, @Nullable JsExpression callee, @NotNull CallableDescriptor descriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull TranslationContext context) {
        this.qualifier = qualifier;
        this.callee = callee;
        this.descriptor = descriptor;
        this.context = context;
        this.resolvedCall = call;
        this.isExtensionCall = this.resolvedCall.getReceiverArgument().exists();
    }

    @NotNull
    private CallParameters resolve() {
        JsExpression receiver = this.isExtensionCall ? this.getExtensionFunctionCallReceiver() : null;
        JsExpression functionReference = this.getFunctionReference();
        JsExpression thisObject = this.getThisObject();
        return new CallParameters(receiver, functionReference, thisObject);
    }

    @NotNull
    private JsExpression getFunctionReference() {
        if (this.callee != null) {
            return this.callee;
        }
        if (!(this.resolvedCall instanceof VariableAsFunctionResolvedCall)) {
            return ReferenceTranslator.translateAsLocalNameReference(this.descriptor, this.context);
        }
        ResolvedCallWithTrace<FunctionDescriptor> call = ((VariableAsFunctionResolvedCall)this.resolvedCall).getFunctionCall();
        return CallBuilder.build(this.context).resolvedCall(call).translate();
    }

    @Nullable
    private JsExpression getThisObject() {
        if (this.qualifier != null && !this.isExtensionCall) {
            return this.qualifier;
        }
        return this.context.thisAliasProvider().get(this.resolvedCall);
    }

    @NotNull
    private JsExpression getExtensionFunctionCallReceiver() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        DeclarationDescriptor receiverDescriptor = JsDescriptorUtils.getDeclarationDescriptorForExtensionCallReceiver(this.resolvedCall);
        return this.context.getThisObject(receiverDescriptor);
    }
}

