/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class QualifiedNamesUtil {
    private QualifiedNamesUtil() {
    }

    public static boolean isSubpackageOf(@NotNull FqName subpackageName, @NotNull FqName packageName) {
        String packageNameStr;
        if (subpackageName.equals(packageName)) {
            return true;
        }
        if (packageName.isRoot()) {
            return true;
        }
        String subpackageNameStr = subpackageName.asString();
        return subpackageNameStr.startsWith(packageNameStr = packageName.asString()) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }

    public static boolean isOneSegmentFQN(@NotNull String fqn) {
        if (fqn.isEmpty()) {
            return false;
        }
        return fqn.indexOf(46) < 0;
    }

    public static boolean isOneSegmentFQN(@NotNull FqName fqn) {
        return QualifiedNamesUtil.isOneSegmentFQN(fqn.asString());
    }

    @NotNull
    public static String getFirstSegment(@NotNull String fqn) {
        int dotIndex = fqn.indexOf(46);
        return dotIndex != -1 ? fqn.substring(0, dotIndex) : fqn;
    }

    @NotNull
    public static FqName withoutLastSegment(@NotNull FqName fqName) {
        return fqName.parent();
    }

    @NotNull
    public static FqName withoutFirstSegment(@NotNull FqName fqName) {
        if (fqName.isRoot() || fqName.parent().isRoot()) {
            return FqName.ROOT;
        }
        String fqNameStr = fqName.asString();
        return new FqName(fqNameStr.substring(fqNameStr.indexOf(46), fqNameStr.length()));
    }

    @NotNull
    public static FqName combine(@NotNull FqName first, @NotNull Name second) {
        return first.child(second);
    }

    @NotNull
    public static String tail(@NotNull FqName headFQN, @NotNull FqName fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, headFQN) || headFQN.isRoot()) {
            return fullFQN.asString();
        }
        return fullFQN.equals(headFQN) ? "" : fullFQN.asString().substring(headFQN.asString().length() + 1);
    }

    @Nullable
    public static FqName plusOneSegment(@NotNull FqName fqn, @NotNull FqName fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, fqn)) {
            return null;
        }
        String nextSegment = QualifiedNamesUtil.getFirstSegment(QualifiedNamesUtil.tail(fqn, fullFQN));
        if (QualifiedNamesUtil.isOneSegmentFQN(nextSegment)) {
            return QualifiedNamesUtil.combine(fqn, Name.guess(nextSegment));
        }
        return null;
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull FqName fqName) {
        if (alreadyImported.hasAlias()) {
            return false;
        }
        if (alreadyImported.isAllUnder() && !fqName.isRoot()) {
            return alreadyImported.fqnPart().equals(fqName.parent());
        }
        return alreadyImported.fqnPart().equals(fqName);
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull ImportPath newImport) {
        if (newImport.isAllUnder() || newImport.hasAlias()) {
            return alreadyImported.equals(newImport);
        }
        return QualifiedNamesUtil.isImported(alreadyImported, newImport.fqnPart());
    }

    public static boolean isImported(@NotNull Iterable<ImportPath> imports, @NotNull ImportPath newImport) {
        for (ImportPath alreadyImported : imports) {
            if (!QualifiedNamesUtil.isImported(alreadyImported, newImport)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        class State {
            State() {
            }
        }
        State BEGINNING = new State();
        State MIDDLE = new State();
        State AFTER_DOT = new State();
        State state = BEGINNING;
        int length = qualifiedName.length();
        for (int i = 0; i < length; ++i) {
            char c = qualifiedName.charAt(i);
            if (state == BEGINNING || state == AFTER_DOT) {
                if (!Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                state = MIDDLE;
                continue;
            }
            if (state != MIDDLE) continue;
            if (c == '.') {
                state = AFTER_DOT;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return state != AFTER_DOT;
    }
}

