/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JvmAbi {
    public static final int VERSION = 6;
    public static final String TRAIT_IMPL_CLASS_NAME = "$TImpl";
    public static final String TRAIT_IMPL_SUFFIX = "$$TImpl";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String CLASS_OBJECT_CLASS_NAME = "object";
    public static final String CLASS_OBJECT_SUFFIX = "$object";
    public static final String DELEGATED_PROPERTY_NAME_POSTFIX = "$delegate";
    public static final String INSTANCE_FIELD = "instance$";
    public static final String CLASS_OBJECT_FIELD = "object$";
    public static final String RECEIVER_PARAMETER = "$receiver";
    public static final JvmClassName JETBRAINS_NOT_NULL_ANNOTATION = JvmClassName.byFqNameWithoutInnerClasses("org.jetbrains.annotations.NotNull");
    public static final JvmClassName JETBRAINS_MUTABLE_ANNOTATION = JvmClassName.byFqNameWithoutInnerClasses("org.jetbrains.annotations.Mutable");
    public static final JvmClassName JETBRAINS_READONLY_ANNOTATION = JvmClassName.byFqNameWithoutInnerClasses("org.jetbrains.annotations.ReadOnly");

    public static boolean isClassObjectFqName(@NotNull FqName fqName) {
        return fqName.lastSegmentIs(Name.identifier(CLASS_OBJECT_CLASS_NAME));
    }

    public static String getPropertyDelegateName(@NotNull Name name) {
        return name.asString() + DELEGATED_PROPERTY_NAME_POSTFIX;
    }

    public static String getDefaultPropertyName(Name propertyName, boolean isDelegated, boolean isExtensionProperty) {
        if (isDelegated) {
            return JvmAbi.getPropertyDelegateName(propertyName);
        }
        String name = propertyName.asString();
        if (isExtensionProperty) {
            name = name + "$ext";
        }
        return name;
    }

    private JvmAbi() {
    }
}

