/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public final class ConcurrentWeakValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    @Override
    protected ConcurrentRefValueHashMap.MyReference<K, V> createRef(K key, V value) {
        return new MyWeakReference(key, value, this.myQueue);
    }

    private static class MyWeakReference<K, T>
    extends WeakReference<T>
    implements ConcurrentRefValueHashMap.MyReference<K, T> {
        private final K key;

        private MyWeakReference(K key, T referent, ReferenceQueue<T> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.MyReference that = (ConcurrentRefValueHashMap.MyReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

