/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;

public class SpinAllocator<T> {
    private final AtomicBoolean[] myEmployed = new AtomicBoolean[64];
    private final Object[] myObjects = new Object[64];
    protected final ICreator<T> myCreator;
    protected final IDisposer<T> myDisposer;

    public SpinAllocator(ICreator<T> creator, IDisposer<T> disposer) {
        this.myCreator = creator;
        this.myDisposer = disposer;
        for (int i = 0; i < 64; ++i) {
            this.myEmployed[i] = new AtomicBoolean(false);
        }
    }

    public T alloc() {
        for (int i = 0; i < 64; ++i) {
            if (this.myEmployed[i].getAndSet(true)) continue;
            Object result = this.myObjects[i];
            if (result == null) {
                this.myObjects[i] = result = this.myCreator.createInstance();
            }
            return (T)result;
        }
        throw new AllocatorExhaustedException();
    }

    public void dispose(T instance) {
        for (int i = 0; i < 64; ++i) {
            if (this.myObjects[i] != instance) continue;
            if (!this.myEmployed[i].get()) {
                throw new AllocatorDisposeException("Instance is already disposed.");
            }
            this.myDisposer.disposeInstance(instance);
            this.myEmployed[i].set(false);
            return;
        }
        throw new AllocatorDisposeException("Attempt to dispose non-allocated instance.");
    }

    public static class AllocatorDisposeException
    extends RuntimeException {
        public AllocatorDisposeException(@NonNls String message) {
            super(message);
        }
    }

    public static class AllocatorExhaustedException
    extends RuntimeException {
        public AllocatorExhaustedException() {
            super("SpinAllocator has exhausted! Too many threads or you're going to get StackOverflow.");
        }
    }

    public static interface IDisposer<T> {
        public void disposeInstance(T var1);
    }

    public static interface ICreator<T> {
        public T createInstance();
    }
}

