/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ExecutorsQuery");
    private final List<QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExecutorsQuery.<init> must not be null");
        }
        if (executors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExecutorsQuery.<init> must not be null");
        }
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExecutorsQuery.processResults must not be null");
        }
        for (QueryExecutor<Result, Parameter> executor : this.myExecutors) {
            try {
                if (executor.execute(this.myParameters, consumer)) continue;
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }
}

