/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        Object v2 = map.get(key);
        if (v2 != null) {
            v = v2;
            if (v == null) throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
            return v;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        v = prev == null ? defaultValue : prev;
        if (v != null) return v;
        throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(final @NonNls @NotNull String threadFactoryName, final int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not be null");
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadFactoryName);
                thread.setDaemon(true);
                thread.setPriority(threadPriority);
                return thread;
            }
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not return null");
        }
        return scheduledThreadPoolExecutor;
    }
}

