/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.TLongArrayList;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.CachedValueImpl");
    private volatile SoftReference<Data<T>> myData = null;

    protected Data<T> computeData(T value, Object[] dependencies) {
        if (dependencies == null) {
            return new Data<T>(value, null, null);
        }
        TLongArrayList timeStamps = new TLongArrayList(dependencies.length);
        ArrayList<Object> deps = new ArrayList<Object>(dependencies.length);
        this.collectDependencies(timeStamps, deps, dependencies);
        return new Data<T>(value, ArrayUtil.toObjectArray(deps), timeStamps.toNativeArray());
    }

    protected void setValue(T value, CachedValueProvider.Result<T> result) {
        this.myData = new SoftReference<Data<Object>>(this.computeData(value == null ? ObjectUtils.NULL : value, this.getDependencies(result)));
    }

    @Nullable
    protected Object[] getDependencies(CachedValueProvider.Result<T> result) {
        return result == null ? null : result.getDependencyItems();
    }

    @Nullable
    protected Object[] getDependenciesPlusValue(CachedValueProvider.Result<T> result) {
        Object[] objectArray;
        if (result == null) {
            return null;
        }
        Object[] items = result.getDependencyItems();
        T value = result.getValue();
        if (value == null) {
            objectArray = items;
        } else if (items == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        } else {
            objectArray = ArrayUtil.append(items, value);
        }
        return objectArray;
    }

    public void clear() {
        this.myData = null;
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull(false) != null;
    }

    @Nullable
    private T getUpToDateOrNull(boolean dispose) {
        Data<T> data = this.getData();
        if (data != null) {
            Object value = ((Data)data).myValue;
            if (this.isUpToDate(data)) {
                return (T)value;
            }
            if (dispose && value instanceof Disposable) {
                Disposer.dispose((Disposable)value);
            }
        }
        return null;
    }

    @Nullable
    private Data<T> getData() {
        SoftReference<Data<T>> ref = this.myData;
        return ref == null ? null : (Data)ref.get();
    }

    protected boolean isUpToDate(@NotNull Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CachedValueBase.isUpToDate must not be null");
        }
        if (data.myTimeStamps == null) {
            return true;
        }
        for (int i = 0; i < data.myDependencies.length; ++i) {
            Object dependency = data.myDependencies[i];
            if (dependency == null || !this.isDependencyOutOfDate(dependency, data.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private void collectDependencies(TLongArrayList timeStamps, List<Object> resultingDeps, Object[] dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null || dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                this.collectDependencies(timeStamps, resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
            timeStamps.add(this.getTimeStamp(dependency));
        }
    }

    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(CachedValueProvider.Result<T> result) {
        T value = result == null ? null : (T)result.getValue();
        this.setValue(value, result);
        return value;
    }

    public abstract boolean isFromMyProject(Project var1);

    @Nullable
    protected <P> T getValueWithLock(P param) {
        T value = this.getUpToDateOrNull(true);
        if (value != null) {
            return value == ObjectUtils.NULL ? null : (T)value;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard("cachedValue").markStack();
        CachedValueProvider.Result<T> result = this.doCompute(param);
        if (stamp.mayCacheNow()) {
            return this.setValue(result);
        }
        return result == null ? null : (T)result.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    protected static class Data<T>
    implements Disposable {
        private final T myValue;
        private final Object[] myDependencies;
        private final long[] myTimeStamps;

        public Data(T value, Object[] dependencies, long[] timeStamps) {
            this.myValue = value;
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
        }

        @Override
        public void dispose() {
            if (this.myValue instanceof Disposable) {
                Disposer.dispose((Disposable)this.myValue);
            }
        }
    }
}

