/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<H, T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.<init> must not be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.<init> must not be null");
        }
        super(name);
        this.myFunction = function;
    }

    public final T getValue(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.getValue must not be null");
        }
        T result = this.getCachedValueOrNull(h);
        if (result != null) {
            return result;
        }
        result = this.myFunction.fun(h);
        long count = h.getManager().getModificationTracker().getJavaStructureModificationCount();
        h.putUserData(this, new SoftReference<Pair<Long, T>>(new Pair<Long, T>(count, result)));
        return result;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        Pair data;
        if (h == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.getCachedValueOrNull must not be null");
        }
        SoftReference ref = (SoftReference)h.getUserData(this);
        Pair pair = data = ref == null ? null : (Pair)ref.get();
        if (data == null || ((Long)data.getFirst()).longValue() != h.getManager().getModificationTracker().getJavaStructureModificationCount()) {
            return null;
        }
        return (T)data.getSecond();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.create must not be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiCacheKey.create must not be null");
        }
        return new PsiCacheKey<T, H>(name, function);
    }
}

