/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiTypeElementImpl");
    private volatile PsiType myCachedType = null;
    private volatile SoftReference<PsiType> myCachedDetachedType = null;
    private static final Function<PsiAnnotation, String> ANNOTATION_TEXT = new Function<PsiAnnotation, String>(){

        @Override
        public String fun(PsiAnnotation psiAnnotation) {
            return psiAnnotation.getText();
        }
    };

    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    protected PsiTypeElementImpl(IElementType type) {
        super(type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedType = null;
        this.myCachedDetachedType = null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType;
        PsiType cachedType = this.myCachedType;
        if (cachedType != null) {
            psiType = cachedType;
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getType must not return null");
            return psiType;
        }
        ArrayList<PsiAnnotation> typeAnnotations = new ArrayList<PsiAnnotation>();
        TreeElement element = this.getFirstChildNode();
        while (element != null) {
            block18: {
                PsiAnnotation[] array;
                IElementType elementType;
                block20: {
                    PsiType componentType;
                    block19: {
                        elementType = element.getElementType();
                        if (element.getTreeNext() != null || !ElementType.PRIMITIVE_TYPE_BIT_SET.contains(elementType)) break block19;
                        PsiImplUtil.addTypeUseAnnotationsFromModifierList(this.getParent(), typeAnnotations);
                        array = PsiTypeElementImpl.toAnnotationsArray(typeAnnotations);
                        cachedType = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createPrimitiveType(element.getText(), array);
                        break block18;
                    }
                    if (elementType != JavaElementType.TYPE) break block20;
                    IElementType tailType = this.getLastChildNode().getElementType();
                    if (tailType == JavaTokenType.ELLIPSIS) {
                        componentType = ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(element)).getType();
                        cachedType = new PsiEllipsisType(componentType);
                        break block18;
                    } else if (tailType == JavaTokenType.RBRACKET) {
                        componentType = ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(element)).getType();
                        cachedType = componentType.createArrayType();
                        break block18;
                    } else {
                        PsiElement opElement = PsiTreeUtil.skipSiblingsForward(element.getPsi(), PsiWhiteSpace.class);
                        List<PsiTypeElement> typeElements = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiTypeElement.class);
                        List<PsiType> types = ContainerUtil.map(typeElements, new Function<PsiTypeElement, PsiType>(){

                            @Override
                            public PsiType fun(PsiTypeElement psiTypeElement) {
                                return psiTypeElement.getType();
                            }
                        });
                        cachedType = opElement instanceof PsiJavaToken && ((PsiJavaToken)opElement).getTokenType() == JavaTokenType.AND ? PsiIntersectionType.createIntersection(types.toArray(new PsiType[types.size()])) : new PsiDisjunctionType(types, this.getManager());
                    }
                    break block18;
                }
                if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                    PsiImplUtil.addTypeUseAnnotationsFromModifierList(this.getParent(), typeAnnotations);
                    array = PsiTypeElementImpl.toAnnotationsArray(typeAnnotations);
                    PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(element);
                    cachedType = new PsiClassReferenceType(reference, null, array);
                } else if (elementType == JavaTokenType.QUEST) {
                    cachedType = this.createWildcardType();
                } else {
                    if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(elementType)) {
                        element = element.getTreeNext();
                        continue;
                    }
                    if (elementType == JavaElementType.ANNOTATION) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
                        PsiAnnotation annotation = elementFactory.createAnnotationFromText(element.getText(), this);
                        typeAnnotations.add(annotation);
                        element = element.getTreeNext();
                        continue;
                    }
                    if (elementType == JavaElementType.DIAMOND_TYPE) {
                        cachedType = new PsiDiamondTypeImpl(this.getManager(), this);
                        break;
                    }
                    LOG.error("Unknown element type: " + elementType);
                }
            }
            if (element.getTextLength() != 0) break;
            element = element.getTreeNext();
        }
        if (cachedType == null) {
            cachedType = PsiType.NULL;
        }
        this.myCachedType = cachedType;
        psiType = cachedType;
        if (psiType != null) return psiType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getType must not return null");
    }

    private static PsiAnnotation[] toAnnotationsArray(List<PsiAnnotation> typeAnnotations) {
        int size = typeAnnotations.size();
        return size == 0 ? PsiAnnotation.EMPTY_ARRAY : typeAnnotations.toArray(new PsiAnnotation[size]);
    }

    public PsiType getDetachedType(@NotNull PsiElement context) {
        PsiType type;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.getDetachedType must not be null");
        }
        SoftReference<PsiType> cached = this.myCachedDetachedType;
        PsiType psiType = type = cached == null ? null : (PsiType)cached.get();
        if (type != null) {
            return type;
        }
        try {
            String combinedAnnotations = this.getCombinedAnnotationsText();
            String text = combinedAnnotations.isEmpty() ? this.getText().trim() : combinedAnnotations + " " + this.getText().trim();
            type = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeFromText(text, context);
            this.myCachedDetachedType = new SoftReference<PsiType>(type);
        }
        catch (IncorrectOperationException e) {
            return this.getType();
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getCombinedAnnotationsText() {
        boolean typeAnnotationsSupported = PsiUtil.isLanguageLevel8OrHigher(this);
        if (!typeAnnotationsSupported) {
            return "";
        }
        String string = StringUtil.join(this.getApplicableAnnotations(), ANNOTATION_TEXT, " ");
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getCombinedAnnotationsText must not return null");
        return string2;
    }

    @Override
    public PsiType getTypeNoResolve(@NotNull PsiElement context) {
        String combinedAnnotations;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.getTypeNoResolve must not be null");
        }
        PsiFile file = this.getContainingFile();
        String text = PsiUtil.isLanguageLevel8OrHigher(file) ? ((combinedAnnotations = StringUtil.join(this.getAnnotations(), ANNOTATION_TEXT, " ")).isEmpty() ? this.getText().trim() : combinedAnnotations + " " + this.getText().trim()) : this.getText().trim();
        try {
            return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeFromText(text, context);
        }
        catch (IncorrectOperationException e) {
            String s = "Parent: " + DebugUtil.psiToString(this.getParent(), false);
            s = s + "Context: " + DebugUtil.psiToString(context, false);
            LOG.error(s, e);
            return null;
        }
    }

    @NotNull
    private PsiType createWildcardType() {
        PsiWildcardType temp;
        if (this.getFirstChildNode().getTreeNext() == null) {
            temp = PsiWildcardType.createUnbounded(this.getManager());
        } else if (this.getLastChildNode().getElementType() == JavaElementType.TYPE) {
            ASTNode keyword;
            PsiTypeElement bound = (PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(this.getLastChildNode());
            for (keyword = this.getFirstChildNode(); keyword != null && keyword.getElementType() != JavaTokenType.EXTENDS_KEYWORD && keyword.getElementType() != JavaTokenType.SUPER_KEYWORD; keyword = keyword.getTreeNext()) {
            }
            if (keyword != null) {
                IElementType i = keyword.getElementType();
                if (i == JavaTokenType.EXTENDS_KEYWORD) {
                    temp = PsiWildcardType.createExtends(this.getManager(), bound.getType());
                } else if (i == JavaTokenType.SUPER_KEYWORD) {
                    temp = PsiWildcardType.createSuper(this.getManager(), bound.getType());
                } else {
                    LOG.assertTrue(false);
                    temp = PsiWildcardType.createUnbounded(this.getManager());
                }
            } else {
                temp = PsiWildcardType.createUnbounded(this.getManager());
            }
        } else {
            temp = PsiWildcardType.createUnbounded(this.getManager());
        }
        PsiWildcardType psiWildcardType = temp;
        if (psiWildcardType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.createWildcardType must not return null");
        }
        return psiWildcardType;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Override
    public PsiAnnotationOwner getOwner(PsiAnnotation annotation) {
        PsiElement next = PsiTreeUtil.skipSiblingsForward(annotation, PsiComment.class, PsiWhiteSpace.class);
        if (next != null && next.getNode().getElementType() == JavaTokenType.LBRACKET) {
            return this.getType();
        }
        return this;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] annotations = this.getAnnotations();
        ArrayList<PsiAnnotation> list = new ArrayList<PsiAnnotation>(Arrays.asList(annotations));
        PsiImplUtil.addTypeUseAnnotationsFromModifierList(this.getParent(), list);
        PsiAnnotation[] psiAnnotationArray = PsiTypeElementImpl.toAnnotationsArray(list);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeElementImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.addAnnotation must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiExpression methodCallCandidate;
        PsiVariable variable;
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiTypeElementImpl.replace must not be null");
        }
        PsiElement result = super.replace(newElement);
        PsiElement parent = result.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        } else if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasInitializer() && (methodCallCandidate = variable.getInitializer()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodCallCandidate;
            CodeEditUtil.markToReformat(methodCallExpression.getArgumentList().getNode(), true);
        }
        return result;
    }
}

