/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkVirtualFileListenerAdapter
implements BulkFileListener {
    private final VirtualFileListener myAdapted;
    private final VirtualFileSystem myFileSystem;

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted) {
        if (adapted == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.<init> must not be null");
        }
        this(adapted, null);
    }

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted, @Nullable VirtualFileSystem fileSystem) {
        if (adapted == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.<init> must not be null");
        }
        this.myAdapted = adapted;
        this.myFileSystem = fileSystem;
    }

    @Override
    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.before must not be null");
        }
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            this.fireBefore(vFileEvent);
        }
    }

    @Override
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter.after must not be null");
        }
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            this.fireAfter(vFileEvent);
        }
    }

    private void fireAfter(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            this.myAdapted.contentsChanged(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileCopyEvent) {
            VFileCopyEvent ce = (VFileCopyEvent)event;
            VirtualFile original = ce.getFile();
            VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
            if (original != null && copy != null) {
                this.myAdapted.fileCopied(new VirtualFileCopyEvent(event.getRequestor(), original, copy));
            }
        } else if (event instanceof VFileCreateEvent) {
            VFileCreateEvent ce = (VFileCreateEvent)event;
            VirtualFile newChild = ce.getFile();
            if (newChild != null) {
                this.myAdapted.fileCreated(new VirtualFileEvent(event.getRequestor(), newChild, ce.getChildName(), ce.getParent()));
            }
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            this.myAdapted.fileDeleted(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            this.myAdapted.fileMoved(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            this.myAdapted.propertyChanged(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }

    private void fireBefore(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            this.myAdapted.beforeContentsChange(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            this.myAdapted.beforeFileDeletion(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            this.myAdapted.beforeFileMovement(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            this.myAdapted.beforePropertyChange(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }
}

