/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VfsUtilCore");

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.isAncestor must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not be null");
        }
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not return null");
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        VirtualFileVisitor.Result result;
        VirtualFileVisitor.Result result2;
        block16: {
            VirtualFileVisitor.Result result3;
            boolean visited;
            boolean pushed;
            block15: {
                if (file == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
                }
                if (visitor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
                }
                pushed = false;
                visited = visitor.allowVisitFile(file);
                if (!visited) break block15;
                VirtualFileVisitor.Result result4 = visitor.visitFileEx(file);
                if (!result4.skipChildren) break block15;
                VirtualFileVisitor.Result result5 = result4;
                visitor.restoreValue(pushed);
                VirtualFileVisitor.Result result6 = result5;
                result2 = result6;
                if (result6 != null) return result2;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not return null");
            }
            Iterable<VirtualFile> childrenIterable = null;
            VirtualFile[] children = null;
            try {
                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                    children = file.getChildren();
                }
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.info("Ignoring: " + e.getMessage());
                VirtualFileVisitor.Result result7 = VirtualFileVisitor.CONTINUE;
                visitor.restoreValue(pushed);
                VirtualFileVisitor.Result result8 = result7;
                result2 = result8;
                if (result8 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not return null");
                return result2;
            }
            try {
                block19: {
                    int len$;
                    VirtualFile[] arr$;
                    block20: {
                        Iterator i$;
                        block18: {
                            block17: {
                                if (childrenIterable == null) break block17;
                                visitor.saveValue();
                                pushed = true;
                                i$ = childrenIterable.iterator();
                                break block18;
                            }
                            if (children == null || children.length == 0) break block19;
                            visitor.saveValue();
                            pushed = true;
                            arr$ = children;
                            len$ = arr$.length;
                            break block20;
                        }
                        while (i$.hasNext()) {
                            VirtualFile child = (VirtualFile)i$.next();
                            VirtualFileVisitor.Result result9 = VfsUtilCore.visitChildrenRecursively(child, visitor);
                            if (result9.skipToParent == null || Comparing.equal(result9.skipToParent, child)) continue;
                            VirtualFileVisitor.Result result10 = result9;
                            VirtualFileVisitor.Result result11 = result10;
                            result2 = result11;
                            if (result11 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not return null");
                            return result2;
                        }
                        break block19;
                    }
                    for (int i$ = 0; i$ < len$; ++i$) {
                        VirtualFile child = arr$[i$];
                        VirtualFileVisitor.Result result12 = VfsUtilCore.visitChildrenRecursively(child, visitor);
                        if (result12.skipToParent == null || Comparing.equal(result12.skipToParent, child)) continue;
                        VirtualFileVisitor.Result result13 = result12;
                        result = result13;
                        break block16;
                    }
                }
                if (visited) {
                    visitor.afterChildrenVisited(file);
                }
                VirtualFileVisitor.Result result14 = VirtualFileVisitor.CONTINUE;
                result3 = result14;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                visitor.restoreValue(pushed);
            }
            result2 = result3;
            if (result3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not return null");
            return result2;
        }
        result2 = result;
        if (result == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not return null");
        return result2;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        if (link == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.isInvalidLink must not be null");
        }
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }
}

