/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

public class PersistentFSConstants {
    private static int ourMaxIntellisenseFilesize = PersistentFSConstants.computeMaxIntellisenseFileSize();

    public static int getMaxIntellisenseFileSize() {
        return ourMaxIntellisenseFilesize;
    }

    private static int computeMaxIntellisenseFileSize() {
        int maxLimitBytes = 0x1400000;
        String userLimitKb = System.getProperty("idea.max.intellisense.filesize");
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, 0x1400000) : 0x1400000;
        }
        catch (NumberFormatException ignored) {
            return 0x1400000;
        }
    }
}

