/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

public class LineTokenizer {
    private int myOffset = 0;
    private int myLength = 0;
    private int myLineSeparatorLength = 0;
    private boolean atEnd = false;
    private CharSequence myText;

    public LineTokenizer(CharSequence text) {
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset = this.myOffset + this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first = this.myText.charAt(i);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }
}

