/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtilRt {
    private static final LoggerRt LOG = LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilLight");
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getExtension must not be null");
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String string = fileName.substring(index + 1);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.getExtension must not return null");
        return string2;
    }

    public static boolean extensionEquals(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.extensionEquals must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.extensionEquals must not be null");
        }
        int extLen = extension.length();
        if (extLen == 0) {
            return fileName.indexOf(46) == -1;
        }
        int extStart = fileName.length() - extLen;
        return extStart >= 1 && fileName.charAt(extStart - 1) == '.' && fileName.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.toSystemDependentName must not be null");
        }
        String string = aFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.toSystemDependentName must not return null");
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.toSystemIndependentName must not be null");
        }
        String string = aFileName.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.toSystemIndependentName must not return null");
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getRelativePath must not be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getRelativePath must not be null");
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        String filePathToCompare;
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getRelativePath must not be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getRelativePath must not be null");
        }
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase();
        String string = filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase();
        if (basePathToCompare.equals(FileUtilRt.ensureEnds(filePathToCompare, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.ensureEnds must not be null");
        }
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.getNameWithoutExtension must not be null");
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.getNameWithoutExtension must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadFile must not be null");
        }
        String string = FileUtilRt.loadFile(file, null, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadFile must not be null");
        }
        String string = FileUtilRt.loadFile(file, encoding, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadFile must not be null");
        }
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        String string = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadFile must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadFileText must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadFileText must not return null");
            }
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        char[] cArray;
        int count;
        int n;
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadText must not be null");
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadText must not return null");
            return cArray;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        cArray = newChars;
        if (newChars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadText must not return null");
    }

    public static boolean isTooLarge(long len) {
        return len > 0x1400000L;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.loadBytes must not be null");
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtilRt.loadBytes must not return null");
        }
        return bytes;
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentFile;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.createParentDirs must not be null");
        }
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.createDirectory must not be null");
        }
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block10: {
            int read;
            if (inputStream == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.copy must not be null");
            }
            if (outputStream == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtilRt.copy must not be null");
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block10;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = BUFFER.get();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }
}

