/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.plugin.JetLanguage;

public final class JetFileUtils {
    private JetFileUtils() {
    }

    @NotNull
    private static String loadFile(@NotNull String path) throws IOException {
        return JetFileUtils.doLoadFile(path);
    }

    @NotNull
    private static String doLoadFile(@NotNull String path) throws IOException {
        String text = FileUtil.loadFile(new File(path), "UTF-8").trim();
        text = StringUtil.convertLineSeparators(text);
        return text;
    }

    @NotNull
    public static JetFile createPsiFile(@NotNull String name, @NotNull String text, @NotNull Project project) {
        String fileName = name.endsWith(".kt") ? name : name + ".jet";
        return (JetFile)JetFileUtils.createFile(fileName, text, project);
    }

    @NotNull
    private static JetFile loadPsiFile(@NotNull String name, @NotNull Project project) {
        try {
            return JetFileUtils.createPsiFile(name, JetFileUtils.loadFile(name), project);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static PsiFile createFile(@NotNull String name, @NotNull String text, @NotNull Project project) {
        LightVirtualFile virtualFile = new LightVirtualFile(name, JetLanguage.INSTANCE, (CharSequence)text);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiFile result = ((PsiFileFactoryImpl)PsiFileFactory.getInstance(project)).trySetupPsiForFile(virtualFile, JetLanguage.INSTANCE, true, false);
        assert (result != null);
        return result;
    }

    @NotNull
    public static List<JetFile> createPsiFileList(@NotNull List<String> inputFiles, @NotNull Project project) {
        ArrayList<JetFile> psiFiles = new ArrayList<JetFile>();
        for (String inputFile : inputFiles) {
            psiFiles.add(JetFileUtils.loadPsiFile(inputFile, project));
        }
        return psiFiles;
    }
}

