/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.closure;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.closure.ClosureContext;

class CaptureClosureVisitor
extends JetTreeVisitor<ClosureContext> {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final DeclarationDescriptor functionDescriptor;

    CaptureClosureVisitor(@NotNull DeclarationDescriptor descriptor, @NotNull BindingContext bindingContext) {
        this.bindingContext = bindingContext;
        this.functionDescriptor = descriptor;
    }

    @Override
    public Void visitJetElement(JetElement element, ClosureContext data) {
        if (element instanceof JetValueArgument) {
            JetExpression expression = ((JetValueArgument)element).getArgumentExpression();
            if (expression != null) {
                expression.accept(this, data);
            }
        } else if (!(element instanceof JetNamedFunction)) {
            return super.visitJetElement(element, data);
        }
        return null;
    }

    @Override
    public Void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @NotNull ClosureContext context) {
        if (expression.getNode().getElementType() == JetNodeTypes.OPERATION_REFERENCE) {
            return null;
        }
        DeclarationDescriptor descriptor = BindingUtils.getNullableDescriptorForReferenceExpression(this.bindingContext, expression);
        if (!(descriptor instanceof VariableDescriptor)) {
            if (descriptor instanceof SimpleFunctionDescriptor && !descriptor.getName().isSpecial()) {
                CaptureClosureVisitor.checkOuterClassDescriptor(descriptor, context);
            }
            return null;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
        if (this.captured(variableDescriptor, context)) {
            context.put(variableDescriptor);
        }
        return null;
    }

    private boolean captured(VariableDescriptor descriptor, ClosureContext context) {
        if (descriptor instanceof PropertyDescriptor) {
            CaptureClosureVisitor.checkOuterClassDescriptor(descriptor, context);
            return false;
        }
        if (CaptureClosureVisitor.isAncestor(this.functionDescriptor, descriptor)) {
            return false;
        }
        if (descriptor instanceof LocalVariableDescriptor && descriptor.isVar()) {
            context.setHasLocalVariables();
            return true;
        }
        PsiElement variableDeclaration = BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor);
        if (variableDeclaration == null) {
            return false;
        }
        return descriptor instanceof ValueParameterDescriptor || !descriptor.isVar() && variableDeclaration instanceof JetProperty || variableDeclaration.getNode().getElementType().equals(JetNodeTypes.LOOP_PARAMETER);
    }

    public static boolean isAncestor(@NotNull DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor) {
        for (DeclarationDescriptor descriptor = declarationDescriptor.getContainingDeclaration(); descriptor != null && !(descriptor instanceof NamespaceDescriptor); descriptor = descriptor.getContainingDeclaration()) {
            if (ancestor != descriptor) continue;
            return true;
        }
        return false;
    }

    private static void checkOuterClassDescriptor(DeclarationDescriptor descriptor, ClosureContext context) {
        DeclarationDescriptor containingDeclaration;
        if (context.outerClassDescriptor == null && (containingDeclaration = descriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
            context.outerClassDescriptor = (ClassDescriptor)containingDeclaration;
        }
    }
}

