/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public enum PrimitiveUnaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final NamePredicate UNARY_OPERATIONS;
    @NotNull
    private static final DescriptorPredicate UNARY_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final Predicate<FunctionDescriptor> PRIMITIVE_UNARY_OPERATION_NAMES;
    @NotNull
    private static final DescriptorPredicate NO_PARAMETERS;
    @NotNull
    private static final Predicate<FunctionDescriptor> PATTERN;

    @Override
    @NotNull
    public Predicate<FunctionDescriptor> getPredicate() {
        return PATTERN;
    }

    @Override
    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor) {
        Name name = descriptor.getName();
        JsUnaryOperator jsOperator = null;
        if ("inv".equals(name.asString())) {
            jsOperator = JsUnaryOperator.BIT_NOT;
        } else {
            JetToken jetToken = OperatorConventions.UNARY_OPERATION_NAMES.inverse().get(name);
            jsOperator = OperatorTable.getUnaryOperator(jetToken);
        }
        final JsUnaryOperator finalJsOperator = jsOperator;
        return new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments.size() == 0) : "Unary operator should not have arguments.";
                return new JsPrefixOperation(finalJsOperator, receiver);
            }
        };
    }

    static {
        UNARY_OPERATIONS = new NamePredicate(OperatorConventions.UNARY_OPERATION_NAMES.values());
        UNARY_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, UNARY_OPERATIONS);
        PRIMITIVE_UNARY_OPERATION_NAMES = Predicates.or(UNARY_OPERATION_FOR_PRIMITIVE_NUMBER, PatternBuilder.pattern("Boolean.not"), PatternBuilder.pattern("Int.inv"));
        NO_PARAMETERS = new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor) {
                assert (descriptor != null);
                return !JsDescriptorUtils.hasParameters(descriptor);
            }
        };
        PATTERN = Predicates.and(PRIMITIVE_UNARY_OPERATION_NAMES, NO_PARAMETERS);
    }
}

