/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerDeclarationTranslator;

class InnerFunctionTranslator
extends InnerDeclarationTranslator {
    private final FunctionDescriptor descriptor;

    public InnerFunctionTranslator(@NotNull JetElement declaration, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context, @NotNull JsFunction fun) {
        super(declaration, descriptor, context, fun);
        this.descriptor = descriptor;
    }

    public boolean isLocalVariablesAffected() {
        return this.closureContext.isLocalVariablesAffected();
    }

    @Override
    protected List<ValueParameterDescriptor> getValueParameters() {
        return this.descriptor.getValueParameters();
    }

    @Override
    @NotNull
    public JsExpression translate(@NotNull JsNameRef nameRef) {
        JsExpression result = this.translate(nameRef, this.getThis());
        FunctionTranslator.addParameters(this.fun.getParameters(), this.descriptor, this.context);
        return result;
    }

    @Override
    protected JsExpression createExpression(JsNameRef nameRef, JsExpression self) {
        return nameRef;
    }

    @Override
    protected JsInvocation createInvocation(JsNameRef nameRef, JsExpression self) {
        JsInvocation bind = new JsInvocation(this.context.namer().kotlin(this.getBindMethodName()));
        bind.getArguments().add(nameRef);
        bind.getArguments().add(self);
        return bind;
    }

    @NotNull
    private JsExpression getThis() {
        ClassDescriptor outerClassDescriptor = this.closureContext.outerClassDescriptor;
        if (outerClassDescriptor != null && this.descriptor.getReceiverParameter() == null) {
            return JsLiteral.THIS;
        }
        return JsLiteral.NULL;
    }

    @NotNull
    private String getBindMethodName() {
        if (this.closureContext.getDescriptors().isEmpty()) {
            return this.getValueParameters().isEmpty() ? "b3" : "b4";
        }
        return this.getValueParameters().isEmpty() ? (this.closureContext.getDescriptors().size() == 1 ? "b0" : "b1") : "b2";
    }

    @Override
    protected List<JsExpression> getCapturedValueParametersList(JsInvocation invocation) {
        if (this.closureContext.getDescriptors().size() > 1 || !this.getValueParameters().isEmpty()) {
            JsArrayLiteral values = new JsArrayLiteral();
            invocation.getArguments().add(values);
            return values.getExpressions();
        }
        return super.getCapturedValueParametersList(invocation);
    }
}

