/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull JetScope scope, @Nullable JetExpression condition, ExpressionTypingContext context) {
        if (condition != null) {
            JetTypeInfo typeInfo = this.facade.getTypeInfo(condition, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope)).replaceExpectedType(KotlinBuiltIns.getInstance().getBooleanType()));
            JetType conditionType = typeInfo.getType();
            if (conditionType != null && !ExpressionTypingUtils.isBoolean(conditionType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition, conditionType));
            }
            return typeInfo.getDataFlowInfo();
        }
        return context.dataFlowInfo;
    }

    @Override
    public JetTypeInfo visitIfExpression(JetIfExpression expression, ExpressionTypingContext context) {
        return this.visitIfExpression(expression, context, false);
    }

    public JetTypeInfo visitIfExpression(JetIfExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = expression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression elseBranch = expression.getElse();
        JetExpression thenBranch = expression.getThen();
        WritableScopeImpl thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Then scope");
        WritableScopeImpl elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Else scope");
        DataFlowInfo thenInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                JetTypeInfo typeInfo = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(thenScope, Collections.singletonList(thenBranch), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(thenInfo), context.trace);
                JetType type = typeInfo.getType();
                DataFlowInfo dataFlowInfo = type != null && KotlinBuiltIns.getInstance().isNothing(type) ? elseInfo : typeInfo.getDataFlowInfo().or(elseInfo);
                return DataFlowUtils.checkImplicitCast(DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType), expression, contextWithExpectedType, isStatement, dataFlowInfo);
            }
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        if (thenBranch == null) {
            JetTypeInfo typeInfo = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(elseScope, Collections.singletonList(elseBranch), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(elseInfo), context.trace);
            JetType type = typeInfo.getType();
            DataFlowInfo dataFlowInfo = type != null && KotlinBuiltIns.getInstance().isNothing(type) ? thenInfo : typeInfo.getDataFlowInfo().or(thenInfo);
            return DataFlowUtils.checkImplicitCast(DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType), expression, contextWithExpectedType, isStatement, dataFlowInfo);
        }
        CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
        JetTypeInfo thenTypeInfo = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(thenScope, Collections.singletonList(thenBranch), coercionStrategy, (ExpressionTypingContext)contextWithExpectedType.replaceDataFlowInfo(thenInfo), context.trace);
        JetTypeInfo elseTypeInfo = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(elseScope, Collections.singletonList(elseBranch), coercionStrategy, (ExpressionTypingContext)contextWithExpectedType.replaceDataFlowInfo(elseInfo), context.trace);
        JetType thenType = thenTypeInfo.getType();
        JetType elseType = elseTypeInfo.getType();
        DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        boolean jumpInThen = thenType != null && KotlinBuiltIns.getInstance().isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.getInstance().isNothing(elseType);
        JetTypeInfo result = thenType == null && elseType == null ? JetTypeInfo.create(null, thenDataFlowInfo.or(elseDataFlowInfo)) : (thenType == null || jumpInThen && !jumpInElse ? elseTypeInfo : (elseType == null || jumpInElse && !jumpInThen ? thenTypeInfo : JetTypeInfo.create(CommonSupertypes.commonSupertype(Arrays.asList(thenType, elseType)), thenDataFlowInfo.or(elseDataFlowInfo))));
        return DataFlowUtils.checkImplicitCast(result.getType(), expression, contextWithExpectedType, isStatement, result.getDataFlowInfo());
    }

    @Override
    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext context) {
        return this.visitWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = expression.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression body = expression.getBody();
        if (body != null) {
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in while's condition");
            DataFlowInfo conditionInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context).and(dataFlowInfo);
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo), context.trace);
        }
        if (!this.containsJumpOutOfLoop(expression, context)) {
            dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(dataFlowInfo);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final JetLoopExpression loopExpression, final ExpressionTypingContext context) {
        final boolean[] result = new boolean[]{false};
        loopExpression.accept(new JetTreeVisitor<List<JetLoopExpression>>(){

            @Override
            public Void visitBreakExpression(JetBreakExpression breakExpression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                JetSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element == loopExpression || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == loopExpression) {
                    result[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(JetContinueExpression expression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                if (targetLabel != null && (element = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof JetLoopExpression && !outerLoops.contains(element)) {
                    result[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(JetLoopExpression loopExpression2, List<JetLoopExpression> outerLoops) {
                ArrayList<JetLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression2);
                return (Void)super.visitLoopExpression(loopExpression2, newOuterLoops);
            }
        }, Lists.newArrayList(loopExpression));
        return result[0];
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext context) {
        return this.visitDoWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression body = expression.getBody();
        JetScope conditionScope = context.scope;
        if (body instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression function = (JetFunctionLiteralExpression)body;
            JetFunctionLiteral functionLiteral = function.getFunctionLiteral();
            if (!functionLiteral.hasParameterSpecification()) {
                WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
                conditionScope = writableScope;
                context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, functionLiteral.getBodyExpression().getStatements(), CoercionStrategy.NO_COERCION, context, context.trace);
                context.trace.record(BindingContext.BLOCK, function);
            } else {
                this.facade.getTypeInfo(body, (ExpressionTypingContext)context.replaceScope(context.scope));
            }
            context.trace.report(Errors.UNUSED_FUNCTION_LITERAL.on(function));
        } else if (body != null) {
            WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
            conditionScope = writableScope;
            List<JetElement> block = body instanceof JetBlockExpression ? ((JetBlockExpression)body).getStatements() : Collections.singletonList(body);
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context, context.trace);
        }
        JetExpression condition = expression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition, context);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression, context) ? DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext context) {
        return this.visitForExpression(expression, context, false);
    }

    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression loopRange = expression.getLoopRange();
        JetType expectedParameterType = null;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context.replaceScope(context.scope));
            dataFlowInfo = this.facade.getTypeInfo(loopRange, context).getDataFlowInfo();
            if (loopRangeReceiver != null) {
                expectedParameterType = ControlStructureTypingVisitor.checkIterableConvention(loopRangeReceiver, context);
            }
        }
        WritableScopeImpl loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope with for-loop index");
        JetParameter loopParameter = expression.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = ControlStructureTypingVisitor.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            loopScope.addVariableDescriptor(variableDescriptor);
        } else {
            JetMultiDeclaration multiParameter = expression.getMultiParameter();
            if (multiParameter != null && loopRange != null) {
                JetType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                ExpressionTypingUtils.defineLocalVariablesFromMultiDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
            }
        }
        JetExpression body = expression.getBody();
        if (body != null) {
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo), context.trace);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    private static VariableDescriptor createLoopParameterDescriptor(JetParameter loopParameter, JetType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        DescriptorResolver.checkParameterHasNoValOrVar(context.trace, loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        JetTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), context.scope, loopParameter, context.trace);
            JetType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), loopParameter, expectedParameterType, context.trace);
        }
        VariableDescriptor olderVariable = context.scope.getLocalVariable(variableDescriptor.getName());
        if (olderVariable != null && DescriptorUtils.isLocal(context.scope.getContainingDeclaration(), olderVariable)) {
            PsiElement declaration = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), variableDescriptor);
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
        return variableDescriptor;
    }

    @Nullable
    static JetType checkIterableConvention(@NotNull ExpressionReceiver loopRange, ExpressionTypingContext context) {
        JetExpression loopRangeExpression = loopRange.getExpression();
        Name iterator = Name.identifier("iterator");
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> calls = ExpressionTypingUtils.makeAndResolveFakeCall(loopRange, context, Collections.<JetExpression>emptyList(), iterator);
        Call iteratorCall = calls.getFirst();
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults = calls.getSecond();
        if (iteratorResolutionResults.isSuccess()) {
            ResolvedCall<FunctionDescriptor> iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_CALL, loopRangeExpression, iteratorCall);
            FunctionDescriptor iteratorFunction = iteratorResolvedCall.getResultingDescriptor();
            JetType iteratorType = iteratorFunction.getReturnType();
            JetType hasNextType = ControlStructureTypingVisitor.checkConventionForIterator(context, loopRangeExpression, iteratorType, "hasNext", Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
            if (hasNextType != null && !ExpressionTypingUtils.isBoolean(hasNextType)) {
                context.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
            }
            return ControlStructureTypingVisitor.checkConventionForIterator(context, loopRangeExpression, iteratorType, "next", Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
        }
        if (iteratorResolutionResults.isAmbiguity()) {
            context.trace.report(Errors.ITERATOR_AMBIGUITY.on(loopRangeExpression, iteratorResolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.ITERATOR_MISSING.on(loopRangeExpression));
        }
        return null;
    }

    @Nullable
    private static JetType checkConventionForIterator(@NotNull ExpressionTypingContext context, @NotNull JetExpression loopRangeExpression, @NotNull JetType iteratorType, @NotNull String name, @NotNull DiagnosticFactory1<JetExpression, JetType> ambiguity, @NotNull DiagnosticFactory1<JetExpression, JetType> missing, @NotNull DiagnosticFactory1<JetExpression, JetType> noneApplicable, @NotNull WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = ExpressionTypingUtils.resolveFakeCall(context, new TransientReceiver(iteratorType), Name.identifier(name));
        if (nextResolutionResults.isAmbiguity()) {
            context.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall = nextResolutionResults.getResultingCall();
            context.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall);
            return resolvedCall.getResultingDescriptor().getReturnType();
        }
        return null;
    }

    @Override
    public JetTypeInfo visitTryExpression(JetTryExpression expression, ExpressionTypingContext context) {
        JetType type;
        JetBlockExpression tryBlock = expression.getTryBlock();
        List<JetCatchClause> catchClauses = expression.getCatchClauses();
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        ArrayList<JetType> types = new ArrayList<JetType>();
        for (JetCatchClause catchClause : catchClauses) {
            JetParameter catchParameter = catchClause.getCatchParameter();
            JetExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            DescriptorResolver.checkParameterHasNoValOrVar(context.trace, catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
            VariableDescriptor variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), context.scope, catchParameter, context.trace);
            JetType throwableType = KotlinBuiltIns.getInstance().getThrowable().getDefaultType();
            DataFlowUtils.checkType(variableDescriptor.getType(), catchParameter, context.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            WritableScopeImpl catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Catch scope");
            catchScope.addVariableDescriptor(variableDescriptor);
            JetType type2 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
            if (type2 == null) continue;
            types.add(type2);
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (finallyBlock != null) {
            dataFlowInfo = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        if ((type = this.facade.getTypeInfo(tryBlock, context).getType()) != null) {
            types.add(type);
        }
        if (types.isEmpty()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        return JetTypeInfo.create(CommonSupertypes.commonSupertype(types), dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitThrowExpression(JetThrowExpression expression, ExpressionTypingContext context) {
        JetExpression thrownExpression = expression.getThrownExpression();
        if (thrownExpression != null) {
            JetType throwableType = KotlinBuiltIns.getInstance().getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceScope(context.scope));
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitReturnExpression(JetReturnExpression expression, ExpressionTypingContext context) {
        JetElement element = context.labelResolver.resolveLabel(expression, context);
        JetExpression returnedExpression = expression.getReturnedExpression();
        JetType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration instanceof JetParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
        }
        assert (parentDeclaration != null);
        DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (expression.getTargetLabel() == null) {
            if (containingFunctionDescriptor != null) {
                PsiElement containingFunction = BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor);
                assert (containingFunction != null);
                if (containingFunction instanceof JetFunctionLiteral) {
                    while ((containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor) : null) instanceof JetFunctionLiteral) {
                    }
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                }
                if (containingFunctionDescriptor != null) {
                    expectedType = DescriptorUtils.getFunctionExpectedReturnType(containingFunctionDescriptor, (JetElement)containingFunction);
                }
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
            }
        } else if (element != null) {
            SimpleFunctionDescriptor functionDescriptor = context.trace.get(BindingContext.FUNCTION, element);
            if (functionDescriptor != null) {
                expectedType = DescriptorUtils.getFunctionExpectedReturnType(functionDescriptor, element);
                if (functionDescriptor != containingFunctionDescriptor) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                }
            } else {
                context.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression, expression.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceScope(context.scope));
        } else if (expectedType != TypeUtils.NO_EXPECTED_TYPE && expectedType != null && !KotlinBuiltIns.getInstance().isUnit(expectedType)) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression, expectedType));
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBreakExpression(JetBreakExpression expression, ExpressionTypingContext context) {
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitContinueExpression(JetContinueExpression expression, ExpressionTypingContext context) {
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }
}

