/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.storage;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.WritableSlice;
import org.jetbrains.jet.utils.Nulls;

public class LockBasedStorageManager
implements StorageManager {
    private final Object lock = new Object(){

        public String toString() {
            return "LockBasedStorageManager centralized lock";
        }
    };

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function<K, V> compute, @NotNull StorageManager.ReferenceKind valuesReferenceKind) {
        ConcurrentMap<K, V> map = LockBasedStorageManager.createConcurrentMap(valuesReferenceKind);
        return new MapBasedMemoizedFunctionToNotNull<K, V>(this.lock, map, compute);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function<K, V> compute, @NotNull StorageManager.ReferenceKind valuesReferenceKind) {
        ConcurrentMap<K, V> map = LockBasedStorageManager.createConcurrentMap(valuesReferenceKind);
        return new MapBasedMemoizedFunction<K, V>(this.lock, map, compute);
    }

    private static <K, V> ConcurrentMap<K, V> createConcurrentMap(StorageManager.ReferenceKind referenceKind) {
        return referenceKind == StorageManager.ReferenceKind.WEAK ? new ConcurrentWeakValueHashMap() : new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Computable<T> computable) {
        return new LockBasedNotNullLazyValue<T>(this.lock, computable);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Computable<T> computable, final @NotNull Consumer<T> postCompute) {
        return new LockBasedNotNullLazyValue<T>(this.lock, computable){

            @Override
            protected void postCompute(@NotNull T value) {
                postCompute.consume(value);
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Computable<T> computable) {
        return new LockBasedLazyValue<T>(this.lock, computable);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Computable<T> computable, final @NotNull Consumer<T> postCompute) {
        return new LockBasedLazyValue<T>(this.lock, computable){

            @Override
            protected void postCompute(@Nullable T value) {
                postCompute.consume(value);
            }
        };
    }

    @Override
    @NotNull
    public BindingTrace createSafeTrace(@NotNull BindingTrace originalTrace) {
        return new LockProtectedTrace(this.lock, originalTrace);
    }

    private static class LockProtectedTrace
    implements BindingTrace {
        private final Object lock;
        private final BindingTrace trace;

        public LockProtectedTrace(@NotNull Object lock, @NotNull BindingTrace trace) {
            this.lock = lock;
            this.trace = trace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BindingContext getBindingContext() {
            Object object = this.lock;
            synchronized (object) {
                return this.trace.getBindingContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                this.trace.record(slice, key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            Object object = this.lock;
            synchronized (object) {
                this.trace.record(slice, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.trace.get(slice, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            Object object = this.lock;
            synchronized (object) {
                return this.trace.getKeys(slice);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            Object object = this.lock;
            synchronized (object) {
                this.trace.report(diagnostic);
            }
        }
    }

    private static class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull Object lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function<K, V> compute) {
            super(lock, map, compute);
        }

        @Override
        @NotNull
        public V fun(@NotNull K input) {
            Object result = super.fun(input);
            assert (result != null) : "compute() returned null";
            return result;
        }
    }

    private static class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final Object lock;
        private final ConcurrentMap<K, Object> cache;
        private final Function<K, V> compute;

        public MapBasedMemoizedFunction(@NotNull Object lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function<K, V> compute) {
            this.lock = lock;
            this.cache = map;
            this.compute = compute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public V fun(@NotNull K input) {
            Object value = this.cache.get(input);
            if (value != null) {
                return Nulls.unescape(value);
            }
            Object object = this.lock;
            synchronized (object) {
                value = this.cache.get(input);
                if (value != null) {
                    return Nulls.unescape(value);
                }
                V typedValue = this.compute.fun(input);
                Object oldValue = this.cache.put(input, Nulls.escape(typedValue));
                assert (oldValue == null) : "Race condition detected";
                return typedValue;
            }
        }
    }

    private static class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull Object lock, @NotNull Computable<T> computable) {
            super(lock, computable);
        }

        @Override
        @NotNull
        public T compute() {
            Object result = super.compute();
            assert (result != null) : "compute() returned null";
            return result;
        }
    }

    private static class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final Object lock;
        private final Computable<T> computable;
        @Nullable
        private volatile Object value = null;

        public LockBasedLazyValue(@NotNull Object lock, @NotNull Computable<T> computable) {
            this.lock = lock;
            this.computable = computable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T compute() {
            Object _value = this.value;
            if (_value != null) {
                return (T)Nulls.unescape(_value);
            }
            Object object = this.lock;
            synchronized (object) {
                _value = this.value;
                if (_value != null) {
                    return (T)Nulls.unescape(_value);
                }
                T typedValue = this.computable.compute();
                this.value = Nulls.escape(typedValue);
                this.postCompute(typedValue);
                return typedValue;
            }
        }

        protected void postCompute(T value) {
        }
    }
}

