/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.prop;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.prop.PropertyParseResult;

public class PropertyNameUtils {
    private PropertyNameUtils() {
    }

    @Nullable
    public static PropertyParseResult parseMethodToProperty(@NotNull String methodName) {
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            String propertyName = StringUtil.decapitalize(methodName.substring("get".length()));
            return new PropertyParseResult(propertyName, true);
        }
        if (methodName.startsWith("set") && methodName.length() > "set".length()) {
            String propertyName = StringUtil.decapitalize(methodName.substring("set".length()));
            return new PropertyParseResult(propertyName, false);
        }
        return null;
    }
}

