/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class TaskPrioritizer {
    public static <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<ResolutionCandidate<D>> allDescriptors, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolutionCandidate<D>> local, @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        for (ResolutionCandidate<D> resolvedCall : allDescriptors) {
            if (DescriptorUtils.isLocal(containerOfTheCurrentLocality, resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @Nullable
    public static JetSuperExpression getReceiverSuper(@NotNull ReceiverValue receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @NotNull
    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull JetReferenceExpression functionReference, @NotNull List<CallableDescriptorCollector<? extends D>> callableDescriptorCollectors) {
        JetScope scope;
        ReceiverValue explicitReceiver = context.call.getExplicitReceiver();
        if (explicitReceiver.exists() && explicitReceiver.getType() instanceof NamespaceType) {
            scope = explicitReceiver.getType().getMemberScope();
            explicitReceiver = ReceiverValue.NO_RECEIVER;
        } else {
            scope = context.scope;
        }
        ResolutionTaskHolder result = new ResolutionTaskHolder(functionReference, context, new MyPriorityProvider(context));
        for (CallableDescriptorCollector<D> callableDescriptorCollector : callableDescriptorCollectors) {
            TaskPrioritizer.doComputeTasks(scope, explicitReceiver, name, result, context, callableDescriptorCollector);
        }
        return result.getTasks();
    }

    private static <D extends CallableDescriptor, F extends D> void doComputeTasks(@NotNull JetScope scope, @NotNull ReceiverValue receiver, @NotNull Name name, @NotNull ResolutionTaskHolder<D, F> result, @NotNull BasicCallResolutionContext context, @NotNull CallableDescriptorCollector<? extends D> callableDescriptorCollector) {
        ProgressIndicatorProvider.checkCanceled();
        AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(context.dataFlowInfo, context.trace.getBindingContext());
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(scope);
        boolean hasExplicitThisObject = context.call.getThisObject().exists();
        if (hasExplicitThisObject) {
            implicitReceivers.add(context.call.getThisObject());
        }
        if (receiver.exists()) {
            List<ReceiverValue> variantsForExplicitReceiver = autoCastService.getVariantsForReceiver(receiver);
            ArrayList members = Lists.newArrayList();
            for (ReceiverValue variant : variantsForExplicitReceiver) {
                Collection<? extends D> membersForThisVariant = callableDescriptorCollector.getMembersByName(variant.getType(), name);
                TaskPrioritizer.convertWithReceivers(membersForThisVariant, Collections.singletonList(variant), Collections.singletonList(ReceiverValue.NO_RECEIVER), members, hasExplicitThisObject);
            }
            result.addCandidates(members);
            for (ReceiverValue implicitReceiver : implicitReceivers) {
                Collection<? extends D> memberExtensions = callableDescriptorCollector.getNonMembersByName(implicitReceiver.getType().getMemberScope(), name);
                List<ReceiverValue> variantsForImplicitReceiver = autoCastService.getVariantsForReceiver(implicitReceiver);
                result.addCandidates(TaskPrioritizer.convertWithReceivers(memberExtensions, variantsForImplicitReceiver, variantsForExplicitReceiver, hasExplicitThisObject));
            }
            Collection extensionFunctions = TaskPrioritizer.convertWithImpliedThis(scope, variantsForExplicitReceiver, callableDescriptorCollector.getNonMembersByName(scope, name));
            result.addCandidates(extensionFunctions);
        } else {
            Collection<ResolutionCandidate<D>> functions = TaskPrioritizer.convertWithImpliedThis(scope, Collections.singletonList(receiver), callableDescriptorCollector.getNonExtensionsByName(scope, name));
            ArrayList<ResolutionCandidate<D>> nonlocals = Lists.newArrayList();
            ArrayList<ResolutionCandidate<D>> locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(functions, scope.getContainingDeclaration(), locals, nonlocals);
            result.addCandidates(locals);
            for (ReceiverValue implicitReceiver : implicitReceivers) {
                TaskPrioritizer.doComputeTasks(scope, implicitReceiver, name, result, context, callableDescriptorCollector);
            }
            result.addCandidates(nonlocals);
        }
    }

    private static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(Collection<? extends D> descriptors, Iterable<ReceiverValue> thisObjects, Iterable<ReceiverValue> receiverParameters, boolean hasExplicitThisObject) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        TaskPrioritizer.convertWithReceivers(descriptors, thisObjects, receiverParameters, result, hasExplicitThisObject);
        return result;
    }

    private static <D extends CallableDescriptor> void convertWithReceivers(Collection<? extends D> descriptors, Iterable<ReceiverValue> thisObjects, Iterable<ReceiverValue> receiverParameters, Collection<ResolutionCandidate<D>> result, boolean hasExplicitThisObject) {
        for (ReceiverValue thisObject : thisObjects) {
            for (ReceiverValue receiverParameter : receiverParameters) {
                for (CallableDescriptor extension : descriptors) {
                    if (DescriptorUtils.isConstructorOfStaticNestedClass(extension)) continue;
                    ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(extension);
                    candidate.setThisObject(thisObject);
                    candidate.setReceiverArgument(receiverParameter);
                    candidate.setExplicitReceiverKind(hasExplicitThisObject ? ExplicitReceiverKind.BOTH_RECEIVERS : ExplicitReceiverKind.THIS_OBJECT);
                    result.add(candidate);
                }
            }
        }
    }

    public static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(JetScope scope, Collection<ReceiverValue> receiverParameters, Collection<? extends D> descriptors) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        for (ReceiverValue receiverParameter : receiverParameters) {
            for (CallableDescriptor descriptor : descriptors) {
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setReceiverArgument(receiverParameter);
                candidate.setExplicitReceiverKind(receiverParameter.exists() ? ExplicitReceiverKind.RECEIVER_ARGUMENT : ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                if (!TaskPrioritizer.setImpliedThis(scope, candidate)) continue;
                result.add(candidate);
            }
        }
        if (receiverParameters.size() == 1 && !receiverParameters.iterator().next().exists()) {
            for (CallableDescriptor descriptor : descriptors) {
                if (descriptor.getExpectedThisObject() == null || descriptor.getReceiverParameter() != null) continue;
                DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
                if (descriptor instanceof ConstructorDescriptor) {
                    containingDeclaration = containingDeclaration.getContainingDeclaration();
                }
                if (containingDeclaration == null || !DescriptorUtils.isClassObject(containingDeclaration)) continue;
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setThisObject(((ClassDescriptor)containingDeclaration).getThisAsReceiverParameter().getValue());
                candidate.setExplicitReceiverKind(ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                result.add(candidate);
            }
        }
        return result;
    }

    private static <D extends CallableDescriptor> boolean setImpliedThis(@NotNull JetScope scope, ResolutionCandidate<D> candidate) {
        ReceiverParameterDescriptor expectedThisObject = candidate.getDescriptor().getExpectedThisObject();
        if (expectedThisObject == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(receiver.getType(), expectedThisObject.getType())) continue;
            candidate.setThisObject(expectedThisObject.getValue());
            return true;
        }
        return false;
    }

    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@NotNull BasicCallResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Collection<ResolutionCandidate<D>> candidates) {
        ResolutionTaskHolder result = new ResolutionTaskHolder(functionReference, context, new MyPriorityProvider(context));
        result.addCandidates(candidates);
        return result.getTasks();
    }

    private TaskPrioritizer() {
    }

    private static class MyPriorityProvider<D extends CallableDescriptor>
    implements ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        private final BasicCallResolutionContext context;

        public MyPriorityProvider(BasicCallResolutionContext context) {
            this.context = context;
        }

        @Override
        public int getPriority(ResolutionCandidate<D> call) {
            return (this.isVisible(call) ? 2 : 0) + (this.isSynthesized(call) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private boolean isVisible(ResolutionCandidate<D> call) {
            if (call == null) {
                return false;
            }
            D candidateDescriptor = call.getDescriptor();
            if (ErrorUtils.isError(candidateDescriptor)) {
                return true;
            }
            return Visibilities.isVisible(candidateDescriptor, this.context.scope.getContainingDeclaration());
        }

        private boolean isSynthesized(ResolutionCandidate<D> call) {
            D descriptor = call.getDescriptor();
            return descriptor instanceof CallableMemberDescriptor && CallResolverUtil.isOrOverridesSynthesized((CallableMemberDescriptor)descriptor);
        }
    }
}

